/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.LoggerUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.LoggerType;
import java.io.IOException;
import java.util.Map;

public final class LoggerUpdateContract
implements JsonSerializable<LoggerUpdateContract> {
    private LoggerUpdateParameters innerProperties;

    private LoggerUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public LoggerType loggerType() {
        return this.innerProperties() == null ? null : this.innerProperties().loggerType();
    }

    public LoggerUpdateContract withLoggerType(LoggerType loggerType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerUpdateParameters();
        }
        this.innerProperties().withLoggerType(loggerType);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public LoggerUpdateContract withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerUpdateParameters();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Map<String, String> credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    public LoggerUpdateContract withCredentials(Map<String, String> credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerUpdateParameters();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    public Boolean isBuffered() {
        return this.innerProperties() == null ? null : this.innerProperties().isBuffered();
    }

    public LoggerUpdateContract withIsBuffered(Boolean isBuffered) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerUpdateParameters();
        }
        this.innerProperties().withIsBuffered(isBuffered);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LoggerUpdateContract fromJson(JsonReader jsonReader) throws IOException {
        return (LoggerUpdateContract)jsonReader.readObject(reader -> {
            LoggerUpdateContract deserializedLoggerUpdateContract = new LoggerUpdateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedLoggerUpdateContract.innerProperties = LoggerUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggerUpdateContract;
        });
    }
}

