/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyDescriptionContractProperties;
import java.io.IOException;

public final class PolicyDescriptionContract
extends ProxyResource {
    private PolicyDescriptionContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private PolicyDescriptionContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public Long scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PolicyDescriptionContract fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyDescriptionContract)((Object)jsonReader.readObject(reader -> {
            PolicyDescriptionContract deserializedPolicyDescriptionContract = new PolicyDescriptionContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.innerProperties = PolicyDescriptionContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyDescriptionContract;
        }));
    }
}

