/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ProductEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import java.io.IOException;

public final class ProductTagResourceContractProperties
extends ProductEntityBaseParameters {
    private String id;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ProductTagResourceContractProperties.class);

    public String id() {
        return this.id;
    }

    public ProductTagResourceContractProperties withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ProductTagResourceContractProperties withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ProductTagResourceContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ProductTagResourceContractProperties withTerms(String terms) {
        super.withTerms(terms);
        return this;
    }

    @Override
    public ProductTagResourceContractProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ProductTagResourceContractProperties withApprovalRequired(Boolean approvalRequired) {
        super.withApprovalRequired(approvalRequired);
        return this;
    }

    @Override
    public ProductTagResourceContractProperties withSubscriptionsLimit(Integer subscriptionsLimit) {
        super.withSubscriptionsLimit(subscriptionsLimit);
        return this;
    }

    @Override
    public ProductTagResourceContractProperties withState(ProductState state) {
        super.withState(state);
        return this;
    }

    @Override
    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ProductTagResourceContractProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("terms", this.terms());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeBooleanField("approvalRequired", this.approvalRequired());
        jsonWriter.writeNumberField("subscriptionsLimit", (Number)this.subscriptionsLimit());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ProductTagResourceContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProductTagResourceContractProperties)jsonReader.readObject(reader -> {
            ProductTagResourceContractProperties deserializedProductTagResourceContractProperties = new ProductTagResourceContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("terms".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.withTerms(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("approvalRequired".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.withApprovalRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("subscriptionsLimit".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.withSubscriptionsLimit((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.withState(ProductState.fromString(reader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedProductTagResourceContractProperties.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProductTagResourceContractProperties;
        });
    }
}

