/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RepresentationContract;
import java.io.IOException;
import java.util.List;

public final class ResponseContract
implements JsonSerializable<ResponseContract> {
    private int statusCode;
    private String description;
    private List<RepresentationContract> representations;
    private List<ParameterContract> headers;

    public int statusCode() {
        return this.statusCode;
    }

    public ResponseContract withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ResponseContract withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<RepresentationContract> representations() {
        return this.representations;
    }

    public ResponseContract withRepresentations(List<RepresentationContract> representations) {
        this.representations = representations;
        return this;
    }

    public List<ParameterContract> headers() {
        return this.headers;
    }

    public ResponseContract withHeaders(List<ParameterContract> headers) {
        this.headers = headers;
        return this;
    }

    public void validate() {
        if (this.representations() != null) {
            this.representations().forEach(e -> e.validate());
        }
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("statusCode", this.statusCode);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("representations", this.representations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResponseContract fromJson(JsonReader jsonReader) throws IOException {
        return (ResponseContract)jsonReader.readObject(reader -> {
            ResponseContract deserializedResponseContract = new ResponseContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("statusCode".equals(fieldName)) {
                    deserializedResponseContract.statusCode = reader.getInt();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedResponseContract.description = reader.getString();
                    continue;
                }
                if ("representations".equals(fieldName)) {
                    List representations;
                    deserializedResponseContract.representations = representations = reader.readArray(reader1 -> RepresentationContract.fromJson(reader1));
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedResponseContract.headers = headers = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponseContract;
        });
    }
}

