/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.TagContractInner;
import java.io.IOException;
import java.util.List;

public final class TagCollection
implements JsonSerializable<TagCollection> {
    private List<TagContractInner> value;
    private Long count;
    private String nextLink;

    public List<TagContractInner> value() {
        return this.value;
    }

    public TagCollection withValue(List<TagContractInner> value) {
        this.value = value;
        return this;
    }

    public Long count() {
        return this.count;
    }

    public TagCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public TagCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static TagCollection fromJson(JsonReader jsonReader) throws IOException {
        return (TagCollection)jsonReader.readObject(reader -> {
            TagCollection deserializedTagCollection = new TagCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTagCollection.value = value = reader.readArray(reader1 -> TagContractInner.fromJson(reader1));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedTagCollection.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedTagCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagCollection;
        });
    }
}

