/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TokenBodyParameterContract
implements JsonSerializable<TokenBodyParameterContract> {
    private String name;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(TokenBodyParameterContract.class);

    public String name() {
        return this.name;
    }

    public TokenBodyParameterContract withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public TokenBodyParameterContract withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model TokenBodyParameterContract"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model TokenBodyParameterContract"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static TokenBodyParameterContract fromJson(JsonReader jsonReader) throws IOException {
        return (TokenBodyParameterContract)jsonReader.readObject(reader -> {
            TokenBodyParameterContract deserializedTokenBodyParameterContract = new TokenBodyParameterContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTokenBodyParameterContract.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedTokenBodyParameterContract.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenBodyParameterContract;
        });
    }
}

