/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppProperties;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.Template;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ContainerAppInner
extends Resource {
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="managedBy")
    private String managedBy;
    @JsonProperty(value="properties")
    private ContainerAppProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ContainerAppInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ContainerAppInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String managedBy() {
        return this.managedBy;
    }

    public ContainerAppInner withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    private ContainerAppProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ContainerAppInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ContainerAppInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ContainerAppProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String managedEnvironmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedEnvironmentId();
    }

    public ContainerAppInner withManagedEnvironmentId(String managedEnvironmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withManagedEnvironmentId(managedEnvironmentId);
        return this;
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public ContainerAppInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public String workloadProfileName() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfileName();
    }

    public ContainerAppInner withWorkloadProfileName(String workloadProfileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    public String latestRevisionName() {
        return this.innerProperties() == null ? null : this.innerProperties().latestRevisionName();
    }

    public String latestReadyRevisionName() {
        return this.innerProperties() == null ? null : this.innerProperties().latestReadyRevisionName();
    }

    public String latestRevisionFqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().latestRevisionFqdn();
    }

    public String customDomainVerificationId() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomainVerificationId();
    }

    public Configuration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public ContainerAppInner withConfiguration(Configuration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public Template template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public ContainerAppInner withTemplate(Template template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    public String eventStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().eventStreamEndpoint();
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

