/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.JobProperties;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class JobInner
extends Resource {
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties")
    private JobProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public JobInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private JobProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public JobInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public JobInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public JobProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    public JobInner withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    public String workloadProfileName() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadProfileName();
    }

    public JobInner withWorkloadProfileName(String workloadProfileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    public JobConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public JobInner withConfiguration(JobConfiguration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public JobTemplate template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public JobInner withTemplate(JobTemplate template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundIpAddresses();
    }

    public String eventStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().eventStreamEndpoint();
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

