/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class JobProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private JobProvisioningState provisioningState;
    @JsonProperty(value="environmentId")
    private String environmentId;
    @JsonProperty(value="workloadProfileName")
    private String workloadProfileName;
    @JsonProperty(value="configuration")
    private JobConfiguration configuration;
    @JsonProperty(value="template")
    private JobTemplate template;
    @JsonProperty(value="outboundIpAddresses", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> outboundIpAddresses;
    @JsonProperty(value="eventStreamEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String eventStreamEndpoint;

    public JobProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public JobProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    public JobProperties withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    public JobConfiguration configuration() {
        return this.configuration;
    }

    public JobProperties withConfiguration(JobConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JobTemplate template() {
        return this.template;
    }

    public JobProperties withTemplate(JobTemplate template) {
        this.template = template;
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.template() != null) {
            this.template().validate();
        }
    }
}

