/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.AvailableWorkloadProfilesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AvailableWorkloadProfileInner;
import com.azure.resourcemanager.appcontainers.implementation.AvailableWorkloadProfileImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfile;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfiles;

public final class AvailableWorkloadProfilesImpl
implements AvailableWorkloadProfiles {
    private static final ClientLogger LOGGER = new ClientLogger(AvailableWorkloadProfilesImpl.class);
    private final AvailableWorkloadProfilesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public AvailableWorkloadProfilesImpl(AvailableWorkloadProfilesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AvailableWorkloadProfile> get(String location) {
        PagedIterable<AvailableWorkloadProfileInner> inner = this.serviceClient().get(location);
        return Utils.mapPage(inner, inner1 -> new AvailableWorkloadProfileImpl((AvailableWorkloadProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AvailableWorkloadProfile> get(String location, Context context) {
        PagedIterable<AvailableWorkloadProfileInner> inner = this.serviceClient().get(location, context);
        return Utils.mapPage(inner, inner1 -> new AvailableWorkloadProfileImpl((AvailableWorkloadProfileInner)((Object)inner1), this.manager()));
    }

    private AvailableWorkloadProfilesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

