/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.CertificateInner;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.Certificate;
import com.azure.resourcemanager.appcontainers.models.CertificatePatch;
import com.azure.resourcemanager.appcontainers.models.CertificateProperties;
import java.util.Collections;
import java.util.Map;

public final class CertificateImpl
implements Certificate,
Certificate.Definition,
Certificate.Update {
    private CertificateInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String connectedEnvironmentName;
    private String certificateName;
    private CertificatePatch updateCertificateEnvelope;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public CertificateProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CertificateInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateImpl withExistingConnectedEnvironment(String resourceGroupName, String connectedEnvironmentName) {
        this.resourceGroupName = resourceGroupName;
        this.connectedEnvironmentName = connectedEnvironmentName;
        return this;
    }

    @Override
    public Certificate create() {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.certificateName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Certificate create(Context context) {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.certificateName, this.innerModel(), context).getValue());
        return this;
    }

    CertificateImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new CertificateInner();
        this.serviceManager = serviceManager;
        this.certificateName = name;
    }

    @Override
    public CertificateImpl update() {
        this.updateCertificateEnvelope = new CertificatePatch();
        return this;
    }

    @Override
    public Certificate apply() {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsCertificates().updateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.certificateName, this.updateCertificateEnvelope, Context.NONE).getValue());
        return this;
    }

    @Override
    public Certificate apply(Context context) {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsCertificates().updateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.certificateName, this.updateCertificateEnvelope, context).getValue());
        return this;
    }

    CertificateImpl(CertificateInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.connectedEnvironmentName = Utils.getValueFromIdByName(innerObject.id(), "connectedEnvironments");
        this.certificateName = Utils.getValueFromIdByName(innerObject.id(), "certificates");
    }

    @Override
    public Certificate refresh() {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsCertificates().getWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.certificateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Certificate refresh(Context context) {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironmentsCertificates().getWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.certificateName, context).getValue());
        return this;
    }

    @Override
    public CertificateImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public CertificateImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public CertificateImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateCertificateEnvelope.withTags(tags);
        return this;
    }

    @Override
    public CertificateImpl withProperties(CertificateProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

