/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsDaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.DaprComponentImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprSecretsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentsDaprComponents;
import com.azure.resourcemanager.appcontainers.models.DaprComponent;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;

public final class ConnectedEnvironmentsDaprComponentsImpl
implements ConnectedEnvironmentsDaprComponents {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedEnvironmentsDaprComponentsImpl.class);
    private final ConnectedEnvironmentsDaprComponentsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ConnectedEnvironmentsDaprComponentsImpl(ConnectedEnvironmentsDaprComponentsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DaprComponent> list(String resourceGroupName, String connectedEnvironmentName) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, connectedEnvironmentName);
        return Utils.mapPage(inner, inner1 -> new DaprComponentImpl((DaprComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DaprComponent> list(String resourceGroupName, String connectedEnvironmentName, Context context) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, connectedEnvironmentName, context);
        return Utils.mapPage(inner, inner1 -> new DaprComponentImpl((DaprComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DaprComponent> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        Response<DaprComponentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, connectedEnvironmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprComponentImpl((DaprComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DaprComponent get(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        DaprComponentInner inner = this.serviceClient().get(resourceGroupName, connectedEnvironmentName, componentName);
        if (inner != null) {
            return new DaprComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName, context);
    }

    @Override
    public void delete(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        this.serviceClient().delete(resourceGroupName, connectedEnvironmentName, componentName);
    }

    @Override
    public Response<DaprSecretsCollection> listSecretsWithResponse(String resourceGroupName, String connectedEnvironmentName, String componentName, Context context) {
        Response<DaprSecretsCollectionInner> inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, connectedEnvironmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprSecretsCollectionImpl((DaprSecretsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DaprSecretsCollection listSecrets(String resourceGroupName, String connectedEnvironmentName, String componentName) {
        DaprSecretsCollectionInner inner = this.serviceClient().listSecrets(resourceGroupName, connectedEnvironmentName, componentName);
        if (inner != null) {
            return new DaprSecretsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DaprComponent getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String componentName = Utils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        return (DaprComponent)this.getWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE).getValue();
    }

    @Override
    public Response<DaprComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String componentName = Utils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        return this.getWithResponse(resourceGroupName, connectedEnvironmentName, componentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String componentName = Utils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String componentName = Utils.getValueFromIdByName(id, "daprComponents");
        if (componentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'daprComponents'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, componentName, context);
    }

    private ConnectedEnvironmentsDaprComponentsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DaprComponentImpl define(String name) {
        return new DaprComponentImpl(name, this.manager());
    }
}

