/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStoragesCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentStorageImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentStoragesCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentStoragesCollection;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentsStorages;

public final class ConnectedEnvironmentsStoragesImpl
implements ConnectedEnvironmentsStorages {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedEnvironmentsStoragesImpl.class);
    private final ConnectedEnvironmentsStoragesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ConnectedEnvironmentsStoragesImpl(ConnectedEnvironmentsStoragesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConnectedEnvironmentStoragesCollection> listWithResponse(String resourceGroupName, String connectedEnvironmentName, Context context) {
        Response<ConnectedEnvironmentStoragesCollectionInner> inner = this.serviceClient().listWithResponse(resourceGroupName, connectedEnvironmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConnectedEnvironmentStoragesCollectionImpl((ConnectedEnvironmentStoragesCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ConnectedEnvironmentStoragesCollection list(String resourceGroupName, String connectedEnvironmentName) {
        ConnectedEnvironmentStoragesCollectionInner inner = this.serviceClient().list(resourceGroupName, connectedEnvironmentName);
        if (inner != null) {
            return new ConnectedEnvironmentStoragesCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ConnectedEnvironmentStorage> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        Response<ConnectedEnvironmentStorageInner> inner = this.serviceClient().getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConnectedEnvironmentStorageImpl((ConnectedEnvironmentStorageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConnectedEnvironmentStorage get(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        ConnectedEnvironmentStorageInner inner = this.serviceClient().get(resourceGroupName, connectedEnvironmentName, storageName);
        if (inner != null) {
            return new ConnectedEnvironmentStorageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, connectedEnvironmentName, storageName, context);
    }

    @Override
    public void delete(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        this.serviceClient().delete(resourceGroupName, connectedEnvironmentName, storageName);
    }

    @Override
    public ConnectedEnvironmentStorage getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return (ConnectedEnvironmentStorage)this.getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, Context.NONE).getValue();
    }

    @Override
    public Response<ConnectedEnvironmentStorage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, storageName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = Utils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, storageName, context);
    }

    private ConnectedEnvironmentsStoragesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectedEnvironmentStorageImpl define(String name) {
        return new ConnectedEnvironmentStorageImpl(name, this.manager());
    }
}

