/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsAuthConfigsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AuthConfigInner;
import com.azure.resourcemanager.appcontainers.implementation.AuthConfigImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.AuthConfig;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsAuthConfigs;

public final class ContainerAppsAuthConfigsImpl
implements ContainerAppsAuthConfigs {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsAuthConfigsImpl.class);
    private final ContainerAppsAuthConfigsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsAuthConfigsImpl(ContainerAppsAuthConfigsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AuthConfig> listByContainerApp(String resourceGroupName, String containerAppName) {
        PagedIterable<AuthConfigInner> inner = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName);
        return Utils.mapPage(inner, inner1 -> new AuthConfigImpl((AuthConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AuthConfig> listByContainerApp(String resourceGroupName, String containerAppName, Context context) {
        PagedIterable<AuthConfigInner> inner = this.serviceClient().listByContainerApp(resourceGroupName, containerAppName, context);
        return Utils.mapPage(inner, inner1 -> new AuthConfigImpl((AuthConfigInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AuthConfig> getWithResponse(String resourceGroupName, String containerAppName, String authConfigName, Context context) {
        Response<AuthConfigInner> inner = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, authConfigName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthConfigImpl((AuthConfigInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AuthConfig get(String resourceGroupName, String containerAppName, String authConfigName) {
        AuthConfigInner inner = this.serviceClient().get(resourceGroupName, containerAppName, authConfigName);
        if (inner != null) {
            return new AuthConfigImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String authConfigName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, containerAppName, authConfigName, context);
    }

    @Override
    public void delete(String resourceGroupName, String containerAppName, String authConfigName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, authConfigName);
    }

    @Override
    public AuthConfig getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = Utils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        return (AuthConfig)this.getWithResponse(resourceGroupName, containerAppName, authConfigName, Context.NONE).getValue();
    }

    @Override
    public Response<AuthConfig> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = Utils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, authConfigName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = Utils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, containerAppName, authConfigName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String authConfigName = Utils.getValueFromIdByName(id, "authConfigs");
        if (authConfigName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authConfigs'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, containerAppName, authConfigName, context);
    }

    private ContainerAppsAuthConfigsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthConfigImpl define(String name) {
        return new AuthConfigImpl(name, this.manager());
    }
}

