/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppAuthTokenInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.CustomHostnameAnalysisResultInner;
import com.azure.resourcemanager.appcontainers.fluent.models.SecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppAuthTokenImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppImpl;
import com.azure.resourcemanager.appcontainers.implementation.CustomHostnameAnalysisResultImpl;
import com.azure.resourcemanager.appcontainers.implementation.SecretsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerAppAuthToken;
import com.azure.resourcemanager.appcontainers.models.ContainerApps;
import com.azure.resourcemanager.appcontainers.models.CustomHostnameAnalysisResult;
import com.azure.resourcemanager.appcontainers.models.SecretsCollection;

public final class ContainerAppsImpl
implements ContainerApps {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsImpl.class);
    private final ContainerAppsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsImpl(ContainerAppsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ContainerApp> list() {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new ContainerAppImpl((ContainerAppInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContainerApp> list(Context context) {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new ContainerAppImpl((ContainerAppInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContainerApp> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new ContainerAppImpl((ContainerAppInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContainerApp> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ContainerAppInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new ContainerAppImpl((ContainerAppInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ContainerApp> getByResourceGroupWithResponse(String resourceGroupName, String containerAppName, Context context) {
        Response<ContainerAppInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ContainerAppImpl((ContainerAppInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ContainerApp getByResourceGroup(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String containerAppName) {
        this.serviceClient().delete(resourceGroupName, containerAppName);
    }

    @Override
    public void delete(String resourceGroupName, String containerAppName, Context context) {
        this.serviceClient().delete(resourceGroupName, containerAppName, context);
    }

    @Override
    public Response<CustomHostnameAnalysisResult> listCustomHostnameAnalysisWithResponse(String resourceGroupName, String containerAppName, String customHostname, Context context) {
        Response<CustomHostnameAnalysisResultInner> inner = this.serviceClient().listCustomHostnameAnalysisWithResponse(resourceGroupName, containerAppName, customHostname, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CustomHostnameAnalysisResultImpl((CustomHostnameAnalysisResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CustomHostnameAnalysisResult listCustomHostnameAnalysis(String resourceGroupName, String containerAppName) {
        CustomHostnameAnalysisResultInner inner = this.serviceClient().listCustomHostnameAnalysis(resourceGroupName, containerAppName);
        if (inner != null) {
            return new CustomHostnameAnalysisResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SecretsCollection> listSecretsWithResponse(String resourceGroupName, String containerAppName, Context context) {
        Response<SecretsCollectionInner> inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecretsCollectionImpl((SecretsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SecretsCollection listSecrets(String resourceGroupName, String containerAppName) {
        SecretsCollectionInner inner = this.serviceClient().listSecrets(resourceGroupName, containerAppName);
        if (inner != null) {
            return new SecretsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ContainerAppAuthToken> getAuthTokenWithResponse(String resourceGroupName, String containerAppName, Context context) {
        Response<ContainerAppAuthTokenInner> inner = this.serviceClient().getAuthTokenWithResponse(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ContainerAppAuthTokenImpl((ContainerAppAuthTokenInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ContainerAppAuthToken getAuthToken(String resourceGroupName, String containerAppName) {
        ContainerAppAuthTokenInner inner = this.serviceClient().getAuthToken(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppAuthTokenImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ContainerApp start(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().start(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ContainerApp start(String resourceGroupName, String containerAppName, Context context) {
        ContainerAppInner inner = this.serviceClient().start(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ContainerApp stop(String resourceGroupName, String containerAppName) {
        ContainerAppInner inner = this.serviceClient().stop(resourceGroupName, containerAppName);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ContainerApp stop(String resourceGroupName, String containerAppName, Context context) {
        ContainerAppInner inner = this.serviceClient().stop(resourceGroupName, containerAppName, context);
        if (inner != null) {
            return new ContainerAppImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ContainerApp getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        return (ContainerApp)this.getByResourceGroupWithResponse(resourceGroupName, containerAppName, Context.NONE).getValue();
    }

    @Override
    public Response<ContainerApp> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, containerAppName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        this.delete(resourceGroupName, containerAppName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = Utils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        this.delete(resourceGroupName, containerAppName, context);
    }

    private ContainerAppsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContainerAppImpl define(String name) {
        return new ContainerAppImpl(name, this.manager());
    }
}

