/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionReplicasClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaInner;
import com.azure.resourcemanager.appcontainers.implementation.ReplicaCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.ReplicaImpl;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisionReplicas;
import com.azure.resourcemanager.appcontainers.models.Replica;
import com.azure.resourcemanager.appcontainers.models.ReplicaCollection;

public final class ContainerAppsRevisionReplicasImpl
implements ContainerAppsRevisionReplicas {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsRevisionReplicasImpl.class);
    private final ContainerAppsRevisionReplicasClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ContainerAppsRevisionReplicasImpl(ContainerAppsRevisionReplicasClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Replica> getReplicaWithResponse(String resourceGroupName, String containerAppName, String revisionName, String replicaName, Context context) {
        Response<ReplicaInner> inner = this.serviceClient().getReplicaWithResponse(resourceGroupName, containerAppName, revisionName, replicaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReplicaImpl((ReplicaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Replica getReplica(String resourceGroupName, String containerAppName, String revisionName, String replicaName) {
        ReplicaInner inner = this.serviceClient().getReplica(resourceGroupName, containerAppName, revisionName, replicaName);
        if (inner != null) {
            return new ReplicaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ReplicaCollection> listReplicasWithResponse(String resourceGroupName, String containerAppName, String revisionName, Context context) {
        Response<ReplicaCollectionInner> inner = this.serviceClient().listReplicasWithResponse(resourceGroupName, containerAppName, revisionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReplicaCollectionImpl((ReplicaCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ReplicaCollection listReplicas(String resourceGroupName, String containerAppName, String revisionName) {
        ReplicaCollectionInner inner = this.serviceClient().listReplicas(resourceGroupName, containerAppName, revisionName);
        if (inner != null) {
            return new ReplicaCollectionImpl(inner, this.manager());
        }
        return null;
    }

    private ContainerAppsRevisionReplicasClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

