/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.DaprComponentImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprSecretsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.DaprComponent;
import com.azure.resourcemanager.appcontainers.models.DaprComponents;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;

public final class DaprComponentsImpl
implements DaprComponents {
    private static final ClientLogger LOGGER = new ClientLogger(DaprComponentsImpl.class);
    private final DaprComponentsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public DaprComponentsImpl(DaprComponentsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return Utils.mapPage(inner, inner1 -> new DaprComponentImpl((DaprComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<DaprComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return Utils.mapPage(inner, inner1 -> new DaprComponentImpl((DaprComponentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DaprComponent> getWithResponse(String resourceGroupName, String environmentName, String componentName, Context context) {
        Response<DaprComponentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprComponentImpl((DaprComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DaprComponent get(String resourceGroupName, String environmentName, String componentName) {
        DaprComponentInner inner = this.serviceClient().get(resourceGroupName, environmentName, componentName);
        if (inner != null) {
            return new DaprComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DaprComponent> createOrUpdateWithResponse(String resourceGroupName, String environmentName, String componentName, DaprComponentInner daprComponentEnvelope, Context context) {
        Response<DaprComponentInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, environmentName, componentName, daprComponentEnvelope, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprComponentImpl((DaprComponentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DaprComponent createOrUpdate(String resourceGroupName, String environmentName, String componentName, DaprComponentInner daprComponentEnvelope) {
        DaprComponentInner inner = this.serviceClient().createOrUpdate(resourceGroupName, environmentName, componentName, daprComponentEnvelope);
        if (inner != null) {
            return new DaprComponentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String componentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, componentName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String componentName) {
        this.serviceClient().delete(resourceGroupName, environmentName, componentName);
    }

    @Override
    public Response<DaprSecretsCollection> listSecretsWithResponse(String resourceGroupName, String environmentName, String componentName, Context context) {
        Response<DaprSecretsCollectionInner> inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, environmentName, componentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DaprSecretsCollectionImpl((DaprSecretsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DaprSecretsCollection listSecrets(String resourceGroupName, String environmentName, String componentName) {
        DaprSecretsCollectionInner inner = this.serviceClient().listSecrets(resourceGroupName, environmentName, componentName);
        if (inner != null) {
            return new DaprSecretsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    private DaprComponentsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

