/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.JobsExecutionsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.appcontainers.implementation.JobExecutionImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.JobExecution;
import com.azure.resourcemanager.appcontainers.models.JobsExecutions;

public final class JobsExecutionsImpl
implements JobsExecutions {
    private static final ClientLogger LOGGER = new ClientLogger(JobsExecutionsImpl.class);
    private final JobsExecutionsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public JobsExecutionsImpl(JobsExecutionsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<JobExecution> list(String resourceGroupName, String jobName) {
        PagedIterable<JobExecutionInner> inner = this.serviceClient().list(resourceGroupName, jobName);
        return Utils.mapPage(inner, inner1 -> new JobExecutionImpl((JobExecutionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<JobExecution> list(String resourceGroupName, String jobName, String filter, Context context) {
        PagedIterable<JobExecutionInner> inner = this.serviceClient().list(resourceGroupName, jobName, filter, context);
        return Utils.mapPage(inner, inner1 -> new JobExecutionImpl((JobExecutionInner)inner1, this.manager()));
    }

    private JobsExecutionsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

