/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedCertificateInner;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificate;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificatePatch;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificateProperties;
import java.util.Collections;
import java.util.Map;

public final class ManagedCertificateImpl
implements ManagedCertificate,
ManagedCertificate.Definition,
ManagedCertificate.Update {
    private ManagedCertificateInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String managedCertificateName;
    private ManagedCertificatePatch updateManagedCertificateEnvelope;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ManagedCertificateProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedCertificateInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedCertificateImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public ManagedCertificate create() {
        this.innerObject = this.serviceManager.serviceClient().getManagedCertificates().createOrUpdate(this.resourceGroupName, this.environmentName, this.managedCertificateName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedCertificate create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedCertificates().createOrUpdate(this.resourceGroupName, this.environmentName, this.managedCertificateName, this.innerModel(), context);
        return this;
    }

    ManagedCertificateImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ManagedCertificateInner();
        this.serviceManager = serviceManager;
        this.managedCertificateName = name;
    }

    @Override
    public ManagedCertificateImpl update() {
        this.updateManagedCertificateEnvelope = new ManagedCertificatePatch();
        return this;
    }

    @Override
    public ManagedCertificate apply() {
        this.innerObject = (ManagedCertificateInner)((Object)this.serviceManager.serviceClient().getManagedCertificates().updateWithResponse(this.resourceGroupName, this.environmentName, this.managedCertificateName, this.updateManagedCertificateEnvelope, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedCertificate apply(Context context) {
        this.innerObject = (ManagedCertificateInner)((Object)this.serviceManager.serviceClient().getManagedCertificates().updateWithResponse(this.resourceGroupName, this.environmentName, this.managedCertificateName, this.updateManagedCertificateEnvelope, context).getValue());
        return this;
    }

    ManagedCertificateImpl(ManagedCertificateInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = Utils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.managedCertificateName = Utils.getValueFromIdByName(innerObject.id(), "managedCertificates");
    }

    @Override
    public ManagedCertificate refresh() {
        this.innerObject = (ManagedCertificateInner)((Object)this.serviceManager.serviceClient().getManagedCertificates().getWithResponse(this.resourceGroupName, this.environmentName, this.managedCertificateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedCertificate refresh(Context context) {
        this.innerObject = (ManagedCertificateInner)((Object)this.serviceManager.serviceClient().getManagedCertificates().getWithResponse(this.resourceGroupName, this.environmentName, this.managedCertificateName, context).getValue());
        return this;
    }

    @Override
    public ManagedCertificateImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ManagedCertificateImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ManagedCertificateImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateManagedCertificateEnvelope.withTags(tags);
        return this;
    }

    @Override
    public ManagedCertificateImpl withProperties(ManagedCertificateProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

