/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedCertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedCertificateInner;
import com.azure.resourcemanager.appcontainers.implementation.ManagedCertificateImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificate;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificates;

public final class ManagedCertificatesImpl
implements ManagedCertificates {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedCertificatesImpl.class);
    private final ManagedCertificatesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedCertificatesImpl(ManagedCertificatesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ManagedCertificate> getWithResponse(String resourceGroupName, String environmentName, String managedCertificateName, Context context) {
        Response<ManagedCertificateInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, managedCertificateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedCertificateImpl((ManagedCertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedCertificate get(String resourceGroupName, String environmentName, String managedCertificateName) {
        ManagedCertificateInner inner = this.serviceClient().get(resourceGroupName, environmentName, managedCertificateName);
        if (inner != null) {
            return new ManagedCertificateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String managedCertificateName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, managedCertificateName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String managedCertificateName) {
        this.serviceClient().delete(resourceGroupName, environmentName, managedCertificateName);
    }

    @Override
    public PagedIterable<ManagedCertificate> list(String resourceGroupName, String environmentName) {
        PagedIterable<ManagedCertificateInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return Utils.mapPage(inner, inner1 -> new ManagedCertificateImpl((ManagedCertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedCertificate> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<ManagedCertificateInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return Utils.mapPage(inner, inner1 -> new ManagedCertificateImpl((ManagedCertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public ManagedCertificate getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String managedCertificateName = Utils.getValueFromIdByName(id, "managedCertificates");
        if (managedCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedCertificates'.", id)));
        }
        return (ManagedCertificate)this.getWithResponse(resourceGroupName, environmentName, managedCertificateName, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedCertificate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String managedCertificateName = Utils.getValueFromIdByName(id, "managedCertificates");
        if (managedCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedCertificates'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, managedCertificateName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String managedCertificateName = Utils.getValueFromIdByName(id, "managedCertificates");
        if (managedCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedCertificates'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, managedCertificateName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String managedCertificateName = Utils.getValueFromIdByName(id, "managedCertificates");
        if (managedCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedCertificates'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, managedCertificateName, context);
    }

    private ManagedCertificatesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedCertificateImpl define(String name) {
        return new ManagedCertificateImpl(name, this.manager());
    }
}

