/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.implementation.DiagnosticsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.DiagnosticsImpl;
import com.azure.resourcemanager.appcontainers.models.Diagnostics;
import com.azure.resourcemanager.appcontainers.models.DiagnosticsCollection;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentDiagnostics;

public final class ManagedEnvironmentDiagnosticsImpl
implements ManagedEnvironmentDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentDiagnosticsImpl.class);
    private final ManagedEnvironmentDiagnosticsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentDiagnosticsImpl(ManagedEnvironmentDiagnosticsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DiagnosticsCollection> listDetectorsWithResponse(String resourceGroupName, String environmentName, Context context) {
        Response<DiagnosticsCollectionInner> inner = this.serviceClient().listDetectorsWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticsCollectionImpl((DiagnosticsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DiagnosticsCollection listDetectors(String resourceGroupName, String environmentName) {
        DiagnosticsCollectionInner inner = this.serviceClient().listDetectors(resourceGroupName, environmentName);
        if (inner != null) {
            return new DiagnosticsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Diagnostics> getDetectorWithResponse(String resourceGroupName, String environmentName, String detectorName, Context context) {
        Response<DiagnosticsInner> inner = this.serviceClient().getDetectorWithResponse(resourceGroupName, environmentName, detectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticsImpl((DiagnosticsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Diagnostics getDetector(String resourceGroupName, String environmentName, String detectorName) {
        DiagnosticsInner inner = this.serviceClient().getDetector(resourceGroupName, environmentName, detectorName);
        if (inner != null) {
            return new DiagnosticsImpl(inner, this.manager());
        }
        return null;
    }

    private ManagedEnvironmentDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

