/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentImpl;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentsDiagnostics;

public final class ManagedEnvironmentsDiagnosticsImpl
implements ManagedEnvironmentsDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentsDiagnosticsImpl.class);
    private final ManagedEnvironmentsDiagnosticsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentsDiagnosticsImpl(ManagedEnvironmentsDiagnosticsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ManagedEnvironment> getRootWithResponse(String resourceGroupName, String environmentName, Context context) {
        Response<ManagedEnvironmentInner> inner = this.serviceClient().getRootWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedEnvironmentImpl((ManagedEnvironmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedEnvironment getRoot(String resourceGroupName, String environmentName) {
        ManagedEnvironmentInner inner = this.serviceClient().getRoot(resourceGroupName, environmentName);
        if (inner != null) {
            return new ManagedEnvironmentImpl(inner, this.manager());
        }
        return null;
    }

    private ManagedEnvironmentsDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

