/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.EnvironmentAuthTokenInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkloadProfileStatesInner;
import com.azure.resourcemanager.appcontainers.implementation.EnvironmentAuthTokenImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.implementation.WorkloadProfileStatesImpl;
import com.azure.resourcemanager.appcontainers.models.EnvironmentAuthToken;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironments;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfileStates;

public final class ManagedEnvironmentsImpl
implements ManagedEnvironments {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentsImpl.class);
    private final ManagedEnvironmentsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentsImpl(ManagedEnvironmentsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ManagedEnvironment> list() {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl((ManagedEnvironmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedEnvironment> list(Context context) {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl((ManagedEnvironmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedEnvironment> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl((ManagedEnvironmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedEnvironment> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl((ManagedEnvironmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ManagedEnvironment> getByResourceGroupWithResponse(String resourceGroupName, String environmentName, Context context) {
        Response<ManagedEnvironmentInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedEnvironmentImpl((ManagedEnvironmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedEnvironment getByResourceGroup(String resourceGroupName, String environmentName) {
        ManagedEnvironmentInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, environmentName);
        if (inner != null) {
            return new ManagedEnvironmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String environmentName) {
        this.serviceClient().delete(resourceGroupName, environmentName);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, Context context) {
        this.serviceClient().delete(resourceGroupName, environmentName, context);
    }

    @Override
    public Response<EnvironmentAuthToken> getAuthTokenWithResponse(String resourceGroupName, String environmentName, Context context) {
        Response<EnvironmentAuthTokenInner> inner = this.serviceClient().getAuthTokenWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EnvironmentAuthTokenImpl((EnvironmentAuthTokenInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public EnvironmentAuthToken getAuthToken(String resourceGroupName, String environmentName) {
        EnvironmentAuthTokenInner inner = this.serviceClient().getAuthToken(resourceGroupName, environmentName);
        if (inner != null) {
            return new EnvironmentAuthTokenImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<WorkloadProfileStates> listWorkloadProfileStates(String resourceGroupName, String environmentName) {
        PagedIterable<WorkloadProfileStatesInner> inner = this.serviceClient().listWorkloadProfileStates(resourceGroupName, environmentName);
        return Utils.mapPage(inner, inner1 -> new WorkloadProfileStatesImpl((WorkloadProfileStatesInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WorkloadProfileStates> listWorkloadProfileStates(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<WorkloadProfileStatesInner> inner = this.serviceClient().listWorkloadProfileStates(resourceGroupName, environmentName, context);
        return Utils.mapPage(inner, inner1 -> new WorkloadProfileStatesImpl((WorkloadProfileStatesInner)((Object)inner1), this.manager()));
    }

    @Override
    public ManagedEnvironment getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        return (ManagedEnvironment)this.getByResourceGroupWithResponse(resourceGroupName, environmentName, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedEnvironment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, environmentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        this.delete(resourceGroupName, environmentName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        this.delete(resourceGroupName, environmentName, context);
    }

    private ManagedEnvironmentsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedEnvironmentImpl define(String name) {
        return new ManagedEnvironmentImpl(name, this.manager());
    }
}

