/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentStoragesCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentStorageImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentStoragesCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStoragesCollection;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentsStorages;

public final class ManagedEnvironmentsStoragesImpl
implements ManagedEnvironmentsStorages {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentsStoragesImpl.class);
    private final ManagedEnvironmentsStoragesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentsStoragesImpl(ManagedEnvironmentsStoragesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ManagedEnvironmentStoragesCollection> listWithResponse(String resourceGroupName, String environmentName, Context context) {
        Response<ManagedEnvironmentStoragesCollectionInner> inner = this.serviceClient().listWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedEnvironmentStoragesCollectionImpl((ManagedEnvironmentStoragesCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedEnvironmentStoragesCollection list(String resourceGroupName, String environmentName) {
        ManagedEnvironmentStoragesCollectionInner inner = this.serviceClient().list(resourceGroupName, environmentName);
        if (inner != null) {
            return new ManagedEnvironmentStoragesCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ManagedEnvironmentStorage> getWithResponse(String resourceGroupName, String environmentName, String storageName, Context context) {
        Response<ManagedEnvironmentStorageInner> inner = this.serviceClient().getWithResponse(resourceGroupName, environmentName, storageName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedEnvironmentStorageImpl((ManagedEnvironmentStorageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedEnvironmentStorage get(String resourceGroupName, String environmentName, String storageName) {
        ManagedEnvironmentStorageInner inner = this.serviceClient().get(resourceGroupName, environmentName, storageName);
        if (inner != null) {
            return new ManagedEnvironmentStorageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String storageName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, storageName, context);
    }

    @Override
    public void delete(String resourceGroupName, String environmentName, String storageName) {
        this.serviceClient().delete(resourceGroupName, environmentName, storageName);
    }

    @Override
    public ManagedEnvironmentStorage getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return (ManagedEnvironmentStorage)this.getWithResponse(resourceGroupName, environmentName, storageName, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedEnvironmentStorage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, storageName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, storageName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = Utils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = Utils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, storageName, context);
    }

    private ManagedEnvironmentsStoragesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedEnvironmentStorageImpl define(String name) {
        return new ManagedEnvironmentStorageImpl(name, this.manager());
    }
}

