/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.OperationsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.OperationDetailInner;
import com.azure.resourcemanager.appcontainers.implementation.OperationDetailImpl;
import com.azure.resourcemanager.appcontainers.implementation.Utils;
import com.azure.resourcemanager.appcontainers.models.OperationDetail;
import com.azure.resourcemanager.appcontainers.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationDetail> list() {
        PagedIterable<OperationDetailInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new OperationDetailImpl((OperationDetailInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationDetail> list(Context context) {
        PagedIterable<OperationDetailInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new OperationDetailImpl((OperationDetailInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

