/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final ContainerAppsApiClientImpl client;

    ResourceProvidersClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobExecutionInner>> jobExecutionWithResponseAsync(String resourceGroupName, String jobName, String jobExecutionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.jobExecution(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, jobExecutionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobExecutionInner>> jobExecutionWithResponseAsync(String resourceGroupName, String jobName, String jobExecutionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.jobExecution(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, jobExecutionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobExecutionInner> jobExecutionAsync(String resourceGroupName, String jobName, String jobExecutionName) {
        return this.jobExecutionWithResponseAsync(resourceGroupName, jobName, jobExecutionName).flatMap(res -> Mono.justOrEmpty((Object)((JobExecutionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobExecutionInner> jobExecutionWithResponse(String resourceGroupName, String jobName, String jobExecutionName, Context context) {
        return (Response)this.jobExecutionWithResponseAsync(resourceGroupName, jobName, jobExecutionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobExecutionInner jobExecution(String resourceGroupName, String jobName, String jobExecutionName) {
        return (JobExecutionInner)this.jobExecutionWithResponse(resourceGroupName, jobName, jobExecutionName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/executions/{jobExecutionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<JobExecutionInner>> jobExecution(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @PathParam(value="jobExecutionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

