/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.AuthConfigInner;
import com.azure.resourcemanager.appcontainers.models.AuthPlatform;
import com.azure.resourcemanager.appcontainers.models.GlobalValidation;
import com.azure.resourcemanager.appcontainers.models.HttpSettings;
import com.azure.resourcemanager.appcontainers.models.IdentityProviders;
import com.azure.resourcemanager.appcontainers.models.Login;

public interface AuthConfig {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public AuthPlatform platform();

    public GlobalValidation globalValidation();

    public IdentityProviders identityProviders();

    public Login login();

    public HttpSettings httpSettings();

    public String resourceGroupName();

    public AuthConfigInner innerModel();

    public Update update();

    public AuthConfig refresh();

    public AuthConfig refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithHttpSettings {
            public Update withHttpSettings(HttpSettings var1);
        }

        public static interface WithLogin {
            public Update withLogin(Login var1);
        }

        public static interface WithIdentityProviders {
            public Update withIdentityProviders(IdentityProviders var1);
        }

        public static interface WithGlobalValidation {
            public Update withGlobalValidation(GlobalValidation var1);
        }

        public static interface WithPlatform {
            public Update withPlatform(AuthPlatform var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithPlatform,
    UpdateStages.WithGlobalValidation,
    UpdateStages.WithIdentityProviders,
    UpdateStages.WithLogin,
    UpdateStages.WithHttpSettings {
        public AuthConfig apply();

        public AuthConfig apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithHttpSettings {
            public WithCreate withHttpSettings(HttpSettings var1);
        }

        public static interface WithLogin {
            public WithCreate withLogin(Login var1);
        }

        public static interface WithIdentityProviders {
            public WithCreate withIdentityProviders(IdentityProviders var1);
        }

        public static interface WithGlobalValidation {
            public WithCreate withGlobalValidation(GlobalValidation var1);
        }

        public static interface WithPlatform {
            public WithCreate withPlatform(AuthPlatform var1);
        }

        public static interface WithCreate
        extends WithPlatform,
        WithGlobalValidation,
        WithIdentityProviders,
        WithLogin,
        WithHttpSettings {
            public AuthConfig create();

            public AuthConfig create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingContainerApp(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

