/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.ActiveRevisionsMode;
import com.azure.resourcemanager.appcontainers.models.Dapr;
import com.azure.resourcemanager.appcontainers.models.Ingress;
import com.azure.resourcemanager.appcontainers.models.RegistryCredentials;
import com.azure.resourcemanager.appcontainers.models.Secret;
import com.azure.resourcemanager.appcontainers.models.Service;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Configuration {
    @JsonProperty(value="secrets")
    private List<Secret> secrets;
    @JsonProperty(value="activeRevisionsMode")
    private ActiveRevisionsMode activeRevisionsMode;
    @JsonProperty(value="ingress")
    private Ingress ingress;
    @JsonProperty(value="registries")
    private List<RegistryCredentials> registries;
    @JsonProperty(value="dapr")
    private Dapr dapr;
    @JsonProperty(value="maxInactiveRevisions")
    private Integer maxInactiveRevisions;
    @JsonProperty(value="service")
    private Service service;

    public List<Secret> secrets() {
        return this.secrets;
    }

    public Configuration withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public ActiveRevisionsMode activeRevisionsMode() {
        return this.activeRevisionsMode;
    }

    public Configuration withActiveRevisionsMode(ActiveRevisionsMode activeRevisionsMode) {
        this.activeRevisionsMode = activeRevisionsMode;
        return this;
    }

    public Ingress ingress() {
        return this.ingress;
    }

    public Configuration withIngress(Ingress ingress) {
        this.ingress = ingress;
        return this;
    }

    public List<RegistryCredentials> registries() {
        return this.registries;
    }

    public Configuration withRegistries(List<RegistryCredentials> registries) {
        this.registries = registries;
        return this;
    }

    public Dapr dapr() {
        return this.dapr;
    }

    public Configuration withDapr(Dapr dapr) {
        this.dapr = dapr;
        return this;
    }

    public Integer maxInactiveRevisions() {
        return this.maxInactiveRevisions;
    }

    public Configuration withMaxInactiveRevisions(Integer maxInactiveRevisions) {
        this.maxInactiveRevisions = maxInactiveRevisions;
        return this;
    }

    public Service service() {
        return this.service;
    }

    public Configuration withService(Service service) {
        this.service = service;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.ingress() != null) {
            this.ingress().validate();
        }
        if (this.registries() != null) {
            this.registries().forEach(e -> e.validate());
        }
        if (this.dapr() != null) {
            this.dapr().validate();
        }
        if (this.service() != null) {
            this.service().validate();
        }
    }
}

