/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class CustomDomainConfiguration {
    @JsonProperty(value="customDomainVerificationId", access=JsonProperty.Access.WRITE_ONLY)
    private String customDomainVerificationId;
    @JsonProperty(value="dnsSuffix")
    private String dnsSuffix;
    @JsonProperty(value="certificateValue")
    private byte[] certificateValue;
    @JsonProperty(value="certificatePassword")
    private String certificatePassword;
    @JsonProperty(value="expirationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationDate;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;
    @JsonProperty(value="subjectName", access=JsonProperty.Access.WRITE_ONLY)
    private String subjectName;

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public CustomDomainConfiguration withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public byte[] certificateValue() {
        return CoreUtils.clone((byte[])this.certificateValue);
    }

    public CustomDomainConfiguration withCertificateValue(byte[] certificateValue) {
        this.certificateValue = CoreUtils.clone((byte[])certificateValue);
        return this;
    }

    public String certificatePassword() {
        return this.certificatePassword;
    }

    public CustomDomainConfiguration withCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public void validate() {
    }
}

