/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.DaprSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.util.List;

public interface DaprComponent {
    public String id();

    public String name();

    public String type();

    public String componentType();

    public String version();

    public Boolean ignoreErrors();

    public String initTimeout();

    public List<Secret> secrets();

    public String secretStoreComponent();

    public List<DaprMetadata> metadata();

    public List<String> scopes();

    public String resourceGroupName();

    public DaprComponentInner innerModel();

    public Update update();

    public DaprComponent refresh();

    public DaprComponent refresh(Context var1);

    public Response<DaprSecretsCollection> listSecretsWithResponse(Context var1);

    public DaprSecretsCollection listSecrets();

    public static interface UpdateStages {

        public static interface WithScopes {
            public Update withScopes(List<String> var1);
        }

        public static interface WithMetadata {
            public Update withMetadata(List<DaprMetadata> var1);
        }

        public static interface WithSecretStoreComponent {
            public Update withSecretStoreComponent(String var1);
        }

        public static interface WithSecrets {
            public Update withSecrets(List<Secret> var1);
        }

        public static interface WithInitTimeout {
            public Update withInitTimeout(String var1);
        }

        public static interface WithIgnoreErrors {
            public Update withIgnoreErrors(Boolean var1);
        }

        public static interface WithVersion {
            public Update withVersion(String var1);
        }

        public static interface WithComponentType {
            public Update withComponentType(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithComponentType,
    UpdateStages.WithVersion,
    UpdateStages.WithIgnoreErrors,
    UpdateStages.WithInitTimeout,
    UpdateStages.WithSecrets,
    UpdateStages.WithSecretStoreComponent,
    UpdateStages.WithMetadata,
    UpdateStages.WithScopes {
        public DaprComponent apply();

        public DaprComponent apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithScopes {
            public WithCreate withScopes(List<String> var1);
        }

        public static interface WithMetadata {
            public WithCreate withMetadata(List<DaprMetadata> var1);
        }

        public static interface WithSecretStoreComponent {
            public WithCreate withSecretStoreComponent(String var1);
        }

        public static interface WithSecrets {
            public WithCreate withSecrets(List<Secret> var1);
        }

        public static interface WithInitTimeout {
            public WithCreate withInitTimeout(String var1);
        }

        public static interface WithIgnoreErrors {
            public WithCreate withIgnoreErrors(Boolean var1);
        }

        public static interface WithVersion {
            public WithCreate withVersion(String var1);
        }

        public static interface WithComponentType {
            public WithCreate withComponentType(String var1);
        }

        public static interface WithCreate
        extends WithComponentType,
        WithVersion,
        WithIgnoreErrors,
        WithInitTimeout,
        WithSecrets,
        WithSecretStoreComponent,
        WithMetadata,
        WithScopes {
            public DaprComponent create();

            public DaprComponent create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingConnectedEnvironment(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

