/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.CookieExpiration;
import com.azure.resourcemanager.appcontainers.models.LoginRoutes;
import com.azure.resourcemanager.appcontainers.models.Nonce;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Login {
    @JsonProperty(value="routes")
    private LoginRoutes routes;
    @JsonProperty(value="preserveUrlFragmentsForLogins")
    private Boolean preserveUrlFragmentsForLogins;
    @JsonProperty(value="allowedExternalRedirectUrls")
    private List<String> allowedExternalRedirectUrls;
    @JsonProperty(value="cookieExpiration")
    private CookieExpiration cookieExpiration;
    @JsonProperty(value="nonce")
    private Nonce nonce;

    public LoginRoutes routes() {
        return this.routes;
    }

    public Login withRoutes(LoginRoutes routes) {
        this.routes = routes;
        return this;
    }

    public Boolean preserveUrlFragmentsForLogins() {
        return this.preserveUrlFragmentsForLogins;
    }

    public Login withPreserveUrlFragmentsForLogins(Boolean preserveUrlFragmentsForLogins) {
        this.preserveUrlFragmentsForLogins = preserveUrlFragmentsForLogins;
        return this;
    }

    public List<String> allowedExternalRedirectUrls() {
        return this.allowedExternalRedirectUrls;
    }

    public Login withAllowedExternalRedirectUrls(List<String> allowedExternalRedirectUrls) {
        this.allowedExternalRedirectUrls = allowedExternalRedirectUrls;
        return this;
    }

    public CookieExpiration cookieExpiration() {
        return this.cookieExpiration;
    }

    public Login withCookieExpiration(CookieExpiration cookieExpiration) {
        this.cookieExpiration = cookieExpiration;
        return this;
    }

    public Nonce nonce() {
        return this.nonce;
    }

    public Login withNonce(Nonce nonce) {
        this.nonce = nonce;
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.cookieExpiration() != null) {
            this.cookieExpiration().validate();
        }
        if (this.nonce() != null) {
            this.nonce().validate();
        }
    }
}

