/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.AppResilienciesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;
import com.azure.resourcemanager.appcontainers.implementation.AppResiliencyImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.AppResiliencies;
import com.azure.resourcemanager.appcontainers.models.AppResiliency;

public final class AppResilienciesImpl
implements AppResiliencies {
    private static final ClientLogger LOGGER = new ClientLogger(AppResilienciesImpl.class);
    private final AppResilienciesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public AppResilienciesImpl(AppResilienciesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String appName, String name, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, appName, name, context);
    }

    @Override
    public void delete(String resourceGroupName, String appName, String name) {
        this.serviceClient().delete(resourceGroupName, appName, name);
    }

    @Override
    public Response<AppResiliency> getWithResponse(String resourceGroupName, String appName, String name, Context context) {
        Response<AppResiliencyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, appName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AppResiliencyImpl((AppResiliencyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AppResiliency get(String resourceGroupName, String appName, String name) {
        AppResiliencyInner inner = this.serviceClient().get(resourceGroupName, appName, name);
        if (inner != null) {
            return new AppResiliencyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AppResiliency> list(String resourceGroupName, String appName) {
        PagedIterable<AppResiliencyInner> inner = this.serviceClient().list(resourceGroupName, appName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AppResiliencyImpl((AppResiliencyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AppResiliency> list(String resourceGroupName, String appName, Context context) {
        PagedIterable<AppResiliencyInner> inner = this.serviceClient().list(resourceGroupName, appName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AppResiliencyImpl((AppResiliencyInner)((Object)inner1), this.manager()));
    }

    @Override
    public AppResiliency getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return (AppResiliency)this.getWithResponse(resourceGroupName, appName, name, Context.NONE).getValue();
    }

    @Override
    public Response<AppResiliency> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, appName, name, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, appName, name, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String appName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (appName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "resiliencyPolicies");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resiliencyPolicies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, appName, name, context);
    }

    private AppResilienciesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public AppResiliencyImpl define(String name) {
        return new AppResiliencyImpl(name, this.manager());
    }
}

