/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appcontainers.fluent.AppResilienciesClient;
import com.azure.resourcemanager.appcontainers.fluent.AvailableWorkloadProfilesClient;
import com.azure.resourcemanager.appcontainers.fluent.BillingMetersClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildAuthTokensClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildersClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildsByBuilderResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.BuildsClient;
import com.azure.resourcemanager.appcontainers.fluent.CertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsCertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsDaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsApiClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsAuthConfigsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionReplicasClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsRevisionsClient;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsSourceControlsClient;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentResiliencyPoliciesClient;
import com.azure.resourcemanager.appcontainers.fluent.DaprComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.DaprSubscriptionsClient;
import com.azure.resourcemanager.appcontainers.fluent.DotNetComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.JavaComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.JobsClient;
import com.azure.resourcemanager.appcontainers.fluent.JobsExecutionsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedCertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentUsagesClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.NamespacesClient;
import com.azure.resourcemanager.appcontainers.fluent.OperationsClient;
import com.azure.resourcemanager.appcontainers.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.appcontainers.fluent.UsagesClient;
import com.azure.resourcemanager.appcontainers.implementation.AppResilienciesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.AvailableWorkloadProfilesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.BillingMetersClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.BuildAuthTokensClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.BuildersClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.BuildsByBuilderResourcesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.BuildsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.CertificatesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsCertificatesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsDaprComponentsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsStoragesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientBuilder;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsAuthConfigsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsDiagnosticsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsRevisionReplicasClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsRevisionsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsSourceControlsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprComponentResiliencyPoliciesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprComponentsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprSubscriptionsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.DotNetComponentsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.JavaComponentsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobsExecutionsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedCertificatesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentDiagnosticsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentUsagesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentsDiagnosticsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentsStoragesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.NamespacesClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.OperationsClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.appcontainers.implementation.UsagesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ContainerAppsApiClientBuilder.class)
public final class ContainerAppsApiClientImpl
implements ContainerAppsApiClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AppResilienciesClient appResiliencies;
    private final ContainerAppsAuthConfigsClient containerAppsAuthConfigs;
    private final AvailableWorkloadProfilesClient availableWorkloadProfiles;
    private final BillingMetersClient billingMeters;
    private final BuildersClient builders;
    private final BuildsByBuilderResourcesClient buildsByBuilderResources;
    private final BuildsClient builds;
    private final BuildAuthTokensClient buildAuthTokens;
    private final ConnectedEnvironmentsClient connectedEnvironments;
    private final ConnectedEnvironmentsCertificatesClient connectedEnvironmentsCertificates;
    private final ConnectedEnvironmentsDaprComponentsClient connectedEnvironmentsDaprComponents;
    private final ConnectedEnvironmentsStoragesClient connectedEnvironmentsStorages;
    private final ContainerAppsClient containerApps;
    private final ContainerAppsRevisionsClient containerAppsRevisions;
    private final ContainerAppsRevisionReplicasClient containerAppsRevisionReplicas;
    private final ContainerAppsDiagnosticsClient containerAppsDiagnostics;
    private final ManagedEnvironmentDiagnosticsClient managedEnvironmentDiagnostics;
    private final ManagedEnvironmentsDiagnosticsClient managedEnvironmentsDiagnostics;
    private final JobsClient jobs;
    private final OperationsClient operations;
    private final JobsExecutionsClient jobsExecutions;
    private final ResourceProvidersClient resourceProviders;
    private final ManagedEnvironmentsClient managedEnvironments;
    private final CertificatesClient certificates;
    private final ManagedCertificatesClient managedCertificates;
    private final NamespacesClient namespaces;
    private final DaprComponentResiliencyPoliciesClient daprComponentResiliencyPolicies;
    private final DaprComponentsClient daprComponents;
    private final DaprSubscriptionsClient daprSubscriptions;
    private final ManagedEnvironmentsStoragesClient managedEnvironmentsStorages;
    private final ContainerAppsSourceControlsClient containerAppsSourceControls;
    private final UsagesClient usages;
    private final ManagedEnvironmentUsagesClient managedEnvironmentUsages;
    private final JavaComponentsClient javaComponents;
    private final DotNetComponentsClient dotNetComponents;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppsApiClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AppResilienciesClient getAppResiliencies() {
        return this.appResiliencies;
    }

    @Override
    public ContainerAppsAuthConfigsClient getContainerAppsAuthConfigs() {
        return this.containerAppsAuthConfigs;
    }

    @Override
    public AvailableWorkloadProfilesClient getAvailableWorkloadProfiles() {
        return this.availableWorkloadProfiles;
    }

    @Override
    public BillingMetersClient getBillingMeters() {
        return this.billingMeters;
    }

    @Override
    public BuildersClient getBuilders() {
        return this.builders;
    }

    @Override
    public BuildsByBuilderResourcesClient getBuildsByBuilderResources() {
        return this.buildsByBuilderResources;
    }

    @Override
    public BuildsClient getBuilds() {
        return this.builds;
    }

    @Override
    public BuildAuthTokensClient getBuildAuthTokens() {
        return this.buildAuthTokens;
    }

    @Override
    public ConnectedEnvironmentsClient getConnectedEnvironments() {
        return this.connectedEnvironments;
    }

    @Override
    public ConnectedEnvironmentsCertificatesClient getConnectedEnvironmentsCertificates() {
        return this.connectedEnvironmentsCertificates;
    }

    @Override
    public ConnectedEnvironmentsDaprComponentsClient getConnectedEnvironmentsDaprComponents() {
        return this.connectedEnvironmentsDaprComponents;
    }

    @Override
    public ConnectedEnvironmentsStoragesClient getConnectedEnvironmentsStorages() {
        return this.connectedEnvironmentsStorages;
    }

    @Override
    public ContainerAppsClient getContainerApps() {
        return this.containerApps;
    }

    @Override
    public ContainerAppsRevisionsClient getContainerAppsRevisions() {
        return this.containerAppsRevisions;
    }

    @Override
    public ContainerAppsRevisionReplicasClient getContainerAppsRevisionReplicas() {
        return this.containerAppsRevisionReplicas;
    }

    @Override
    public ContainerAppsDiagnosticsClient getContainerAppsDiagnostics() {
        return this.containerAppsDiagnostics;
    }

    @Override
    public ManagedEnvironmentDiagnosticsClient getManagedEnvironmentDiagnostics() {
        return this.managedEnvironmentDiagnostics;
    }

    @Override
    public ManagedEnvironmentsDiagnosticsClient getManagedEnvironmentsDiagnostics() {
        return this.managedEnvironmentsDiagnostics;
    }

    @Override
    public JobsClient getJobs() {
        return this.jobs;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public JobsExecutionsClient getJobsExecutions() {
        return this.jobsExecutions;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public ManagedEnvironmentsClient getManagedEnvironments() {
        return this.managedEnvironments;
    }

    @Override
    public CertificatesClient getCertificates() {
        return this.certificates;
    }

    @Override
    public ManagedCertificatesClient getManagedCertificates() {
        return this.managedCertificates;
    }

    @Override
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    @Override
    public DaprComponentResiliencyPoliciesClient getDaprComponentResiliencyPolicies() {
        return this.daprComponentResiliencyPolicies;
    }

    @Override
    public DaprComponentsClient getDaprComponents() {
        return this.daprComponents;
    }

    @Override
    public DaprSubscriptionsClient getDaprSubscriptions() {
        return this.daprSubscriptions;
    }

    @Override
    public ManagedEnvironmentsStoragesClient getManagedEnvironmentsStorages() {
        return this.managedEnvironmentsStorages;
    }

    @Override
    public ContainerAppsSourceControlsClient getContainerAppsSourceControls() {
        return this.containerAppsSourceControls;
    }

    @Override
    public UsagesClient getUsages() {
        return this.usages;
    }

    @Override
    public ManagedEnvironmentUsagesClient getManagedEnvironmentUsages() {
        return this.managedEnvironmentUsages;
    }

    @Override
    public JavaComponentsClient getJavaComponents() {
        return this.javaComponents;
    }

    @Override
    public DotNetComponentsClient getDotNetComponents() {
        return this.dotNetComponents;
    }

    ContainerAppsApiClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2023-11-02-preview";
        this.appResiliencies = new AppResilienciesClientImpl(this);
        this.containerAppsAuthConfigs = new ContainerAppsAuthConfigsClientImpl(this);
        this.availableWorkloadProfiles = new AvailableWorkloadProfilesClientImpl(this);
        this.billingMeters = new BillingMetersClientImpl(this);
        this.builders = new BuildersClientImpl(this);
        this.buildsByBuilderResources = new BuildsByBuilderResourcesClientImpl(this);
        this.builds = new BuildsClientImpl(this);
        this.buildAuthTokens = new BuildAuthTokensClientImpl(this);
        this.connectedEnvironments = new ConnectedEnvironmentsClientImpl(this);
        this.connectedEnvironmentsCertificates = new ConnectedEnvironmentsCertificatesClientImpl(this);
        this.connectedEnvironmentsDaprComponents = new ConnectedEnvironmentsDaprComponentsClientImpl(this);
        this.connectedEnvironmentsStorages = new ConnectedEnvironmentsStoragesClientImpl(this);
        this.containerApps = new ContainerAppsClientImpl(this);
        this.containerAppsRevisions = new ContainerAppsRevisionsClientImpl(this);
        this.containerAppsRevisionReplicas = new ContainerAppsRevisionReplicasClientImpl(this);
        this.containerAppsDiagnostics = new ContainerAppsDiagnosticsClientImpl(this);
        this.managedEnvironmentDiagnostics = new ManagedEnvironmentDiagnosticsClientImpl(this);
        this.managedEnvironmentsDiagnostics = new ManagedEnvironmentsDiagnosticsClientImpl(this);
        this.jobs = new JobsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.jobsExecutions = new JobsExecutionsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.managedEnvironments = new ManagedEnvironmentsClientImpl(this);
        this.certificates = new CertificatesClientImpl(this);
        this.managedCertificates = new ManagedCertificatesClientImpl(this);
        this.namespaces = new NamespacesClientImpl(this);
        this.daprComponentResiliencyPolicies = new DaprComponentResiliencyPoliciesClientImpl(this);
        this.daprComponents = new DaprComponentsClientImpl(this);
        this.daprSubscriptions = new DaprSubscriptionsClientImpl(this);
        this.managedEnvironmentsStorages = new ManagedEnvironmentsStoragesClientImpl(this);
        this.containerAppsSourceControls = new ContainerAppsSourceControlsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.managedEnvironmentUsages = new ManagedEnvironmentUsagesClientImpl(this);
        this.javaComponents = new JavaComponentsClientImpl(this);
        this.dotNetComponents = new DotNetComponentsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

