/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentResiliencyPolicyInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicy;
import com.azure.resourcemanager.appcontainers.models.DaprComponentResiliencyPolicyConfiguration;

public final class DaprComponentResiliencyPolicyImpl
implements DaprComponentResiliencyPolicy,
DaprComponentResiliencyPolicy.Definition,
DaprComponentResiliencyPolicy.Update {
    private DaprComponentResiliencyPolicyInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String environmentName;
    private String componentName;
    private String name;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public DaprComponentResiliencyPolicyConfiguration inboundPolicy() {
        return this.innerModel().inboundPolicy();
    }

    @Override
    public DaprComponentResiliencyPolicyConfiguration outboundPolicy() {
        return this.innerModel().outboundPolicy();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DaprComponentResiliencyPolicyInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public DaprComponentResiliencyPolicyImpl withExistingDaprComponent(String resourceGroupName, String environmentName, String componentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        this.componentName = componentName;
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicy create() {
        this.innerObject = (DaprComponentResiliencyPolicyInner)((Object)this.serviceManager.serviceClient().getDaprComponentResiliencyPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicy create(Context context) {
        this.innerObject = (DaprComponentResiliencyPolicyInner)((Object)this.serviceManager.serviceClient().getDaprComponentResiliencyPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.name, this.innerModel(), context).getValue());
        return this;
    }

    DaprComponentResiliencyPolicyImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new DaprComponentResiliencyPolicyInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public DaprComponentResiliencyPolicyImpl update() {
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicy apply() {
        this.innerObject = (DaprComponentResiliencyPolicyInner)((Object)this.serviceManager.serviceClient().getDaprComponentResiliencyPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicy apply(Context context) {
        this.innerObject = (DaprComponentResiliencyPolicyInner)((Object)this.serviceManager.serviceClient().getDaprComponentResiliencyPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.name, this.innerModel(), context).getValue());
        return this;
    }

    DaprComponentResiliencyPolicyImpl(DaprComponentResiliencyPolicyInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.componentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "daprComponents");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resiliencyPolicies");
    }

    @Override
    public DaprComponentResiliencyPolicy refresh() {
        this.innerObject = (DaprComponentResiliencyPolicyInner)((Object)this.serviceManager.serviceClient().getDaprComponentResiliencyPolicies().getWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicy refresh(Context context) {
        this.innerObject = (DaprComponentResiliencyPolicyInner)((Object)this.serviceManager.serviceClient().getDaprComponentResiliencyPolicies().getWithResponse(this.resourceGroupName, this.environmentName, this.componentName, this.name, context).getValue());
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicyImpl withInboundPolicy(DaprComponentResiliencyPolicyConfiguration inboundPolicy) {
        this.innerModel().withInboundPolicy(inboundPolicy);
        return this;
    }

    @Override
    public DaprComponentResiliencyPolicyImpl withOutboundPolicy(DaprComponentResiliencyPolicyConfiguration outboundPolicy) {
        this.innerModel().withOutboundPolicy(outboundPolicy);
        return this;
    }
}

