/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.JobsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppJobExecutionsInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionBaseInner;
import com.azure.resourcemanager.appcontainers.fluent.models.JobInner;
import com.azure.resourcemanager.appcontainers.fluent.models.JobSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppJobExecutionsImpl;
import com.azure.resourcemanager.appcontainers.implementation.DiagnosticsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.DiagnosticsImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobExecutionBaseImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobSecretsCollectionImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ContainerAppJobExecutions;
import com.azure.resourcemanager.appcontainers.models.Diagnostics;
import com.azure.resourcemanager.appcontainers.models.DiagnosticsCollection;
import com.azure.resourcemanager.appcontainers.models.Job;
import com.azure.resourcemanager.appcontainers.models.JobExecutionBase;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import com.azure.resourcemanager.appcontainers.models.JobSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.Jobs;

public final class JobsImpl
implements Jobs {
    private static final ClientLogger LOGGER = new ClientLogger(JobsImpl.class);
    private final JobsClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public JobsImpl(JobsClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DiagnosticsCollection> listDetectorsWithResponse(String resourceGroupName, String jobName, Context context) {
        Response<DiagnosticsCollectionInner> inner = this.serviceClient().listDetectorsWithResponse(resourceGroupName, jobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticsCollectionImpl((DiagnosticsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DiagnosticsCollection listDetectors(String resourceGroupName, String jobName) {
        DiagnosticsCollectionInner inner = this.serviceClient().listDetectors(resourceGroupName, jobName);
        if (inner != null) {
            return new DiagnosticsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Diagnostics> getDetectorWithResponse(String resourceGroupName, String jobName, String detectorName, Context context) {
        Response<DiagnosticsInner> inner = this.serviceClient().getDetectorWithResponse(resourceGroupName, jobName, detectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticsImpl((DiagnosticsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Diagnostics getDetector(String resourceGroupName, String jobName, String detectorName) {
        DiagnosticsInner inner = this.serviceClient().getDetector(resourceGroupName, jobName, detectorName);
        if (inner != null) {
            return new DiagnosticsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Job> proxyGetWithResponse(String resourceGroupName, String jobName, Context context) {
        Response<JobInner> inner = this.serviceClient().proxyGetWithResponse(resourceGroupName, jobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobImpl((JobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Job proxyGet(String resourceGroupName, String jobName) {
        JobInner inner = this.serviceClient().proxyGet(resourceGroupName, jobName);
        if (inner != null) {
            return new JobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Job> list() {
        PagedIterable<JobInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobImpl((JobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Job> list(Context context) {
        PagedIterable<JobInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobImpl((JobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Job> listByResourceGroup(String resourceGroupName) {
        PagedIterable<JobInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobImpl((JobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Job> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<JobInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobImpl((JobInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Job> getByResourceGroupWithResponse(String resourceGroupName, String jobName, Context context) {
        Response<JobInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, jobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobImpl((JobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Job getByResourceGroup(String resourceGroupName, String jobName) {
        JobInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, jobName);
        if (inner != null) {
            return new JobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String jobName) {
        this.serviceClient().delete(resourceGroupName, jobName);
    }

    @Override
    public void delete(String resourceGroupName, String jobName, Context context) {
        this.serviceClient().delete(resourceGroupName, jobName, context);
    }

    @Override
    public JobExecutionBase start(String resourceGroupName, String jobName) {
        JobExecutionBaseInner inner = this.serviceClient().start(resourceGroupName, jobName);
        if (inner != null) {
            return new JobExecutionBaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public JobExecutionBase start(String resourceGroupName, String jobName, JobExecutionTemplate template, Context context) {
        JobExecutionBaseInner inner = this.serviceClient().start(resourceGroupName, jobName, template, context);
        if (inner != null) {
            return new JobExecutionBaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void stopExecution(String resourceGroupName, String jobName, String jobExecutionName) {
        this.serviceClient().stopExecution(resourceGroupName, jobName, jobExecutionName);
    }

    @Override
    public void stopExecution(String resourceGroupName, String jobName, String jobExecutionName, Context context) {
        this.serviceClient().stopExecution(resourceGroupName, jobName, jobExecutionName, context);
    }

    @Override
    public ContainerAppJobExecutions stopMultipleExecutions(String resourceGroupName, String jobName) {
        ContainerAppJobExecutionsInner inner = this.serviceClient().stopMultipleExecutions(resourceGroupName, jobName);
        if (inner != null) {
            return new ContainerAppJobExecutionsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ContainerAppJobExecutions stopMultipleExecutions(String resourceGroupName, String jobName, Context context) {
        ContainerAppJobExecutionsInner inner = this.serviceClient().stopMultipleExecutions(resourceGroupName, jobName, context);
        if (inner != null) {
            return new ContainerAppJobExecutionsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<JobSecretsCollection> listSecretsWithResponse(String resourceGroupName, String jobName, Context context) {
        Response<JobSecretsCollectionInner> inner = this.serviceClient().listSecretsWithResponse(resourceGroupName, jobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobSecretsCollectionImpl((JobSecretsCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobSecretsCollection listSecrets(String resourceGroupName, String jobName) {
        JobSecretsCollectionInner inner = this.serviceClient().listSecrets(resourceGroupName, jobName);
        if (inner != null) {
            return new JobSecretsCollectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Job getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        return (Job)this.getByResourceGroupWithResponse(resourceGroupName, jobName, Context.NONE).getValue();
    }

    @Override
    public Response<Job> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, jobName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        this.delete(resourceGroupName, jobName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        this.delete(resourceGroupName, jobName, context);
    }

    private JobsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobImpl define(String name) {
        return new JobImpl(name, this.manager());
    }
}

