/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.EnvironmentVariable;
import com.azure.resourcemanager.appcontainers.models.PreBuildStep;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BuildConfiguration {
    @JsonProperty(value="baseOs")
    private String baseOs;
    @JsonProperty(value="platform")
    private String platform;
    @JsonProperty(value="platformVersion")
    private String platformVersion;
    @JsonProperty(value="environmentVariables")
    private List<EnvironmentVariable> environmentVariables;
    @JsonProperty(value="preBuildSteps")
    private List<PreBuildStep> preBuildSteps;

    public String baseOs() {
        return this.baseOs;
    }

    public BuildConfiguration withBaseOs(String baseOs) {
        this.baseOs = baseOs;
        return this;
    }

    public String platform() {
        return this.platform;
    }

    public BuildConfiguration withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public BuildConfiguration withPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public BuildConfiguration withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public List<PreBuildStep> preBuildSteps() {
        return this.preBuildSteps;
    }

    public BuildConfiguration withPreBuildSteps(List<PreBuildStep> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
        return this;
    }

    public void validate() {
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.preBuildSteps() != null) {
            this.preBuildSteps().forEach(e -> e.validate());
        }
    }
}

