/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.appcontainers.models.CertificateKeyVaultProperties;
import com.azure.resourcemanager.appcontainers.models.CertificateProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CertificateType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificateProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private CertificateProvisioningState provisioningState;
    @JsonProperty(value="certificateKeyVaultProperties")
    private CertificateKeyVaultProperties certificateKeyVaultProperties;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="subjectName", access=JsonProperty.Access.WRITE_ONLY)
    private String subjectName;
    @JsonProperty(value="subjectAlternativeNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> subjectAlternativeNames;
    @JsonProperty(value="value")
    private byte[] value;
    @JsonProperty(value="issuer", access=JsonProperty.Access.WRITE_ONLY)
    private String issuer;
    @JsonProperty(value="issueDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime issueDate;
    @JsonProperty(value="expirationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationDate;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;
    @JsonProperty(value="valid", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean valid;
    @JsonProperty(value="publicKeyHash", access=JsonProperty.Access.WRITE_ONLY)
    private String publicKeyHash;
    @JsonProperty(value="certificateType")
    private CertificateType certificateType;

    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CertificateKeyVaultProperties certificateKeyVaultProperties() {
        return this.certificateKeyVaultProperties;
    }

    public CertificateProperties withCertificateKeyVaultProperties(CertificateKeyVaultProperties certificateKeyVaultProperties) {
        this.certificateKeyVaultProperties = certificateKeyVaultProperties;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CertificateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public byte[] value() {
        return CoreUtils.clone((byte[])this.value);
    }

    public CertificateProperties withValue(byte[] value) {
        this.value = CoreUtils.clone((byte[])value);
        return this;
    }

    public String issuer() {
        return this.issuer;
    }

    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean valid() {
        return this.valid;
    }

    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    public CertificateType certificateType() {
        return this.certificateType;
    }

    public CertificateProperties withCertificateType(CertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public void validate() {
        if (this.certificateKeyVaultProperties() != null) {
            this.certificateKeyVaultProperties().validate();
        }
    }
}

