/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.util.List;
import java.util.Map;

public interface DaprSubscription {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String pubsubName();

    public String topic();

    public String deadLetterTopic();

    public DaprSubscriptionRoutes routes();

    public List<String> scopes();

    public Map<String, String> metadata();

    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe();

    public String resourceGroupName();

    public DaprSubscriptionInner innerModel();

    public Update update();

    public DaprSubscription refresh();

    public DaprSubscription refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithBulkSubscribe {
            public Update withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions var1);
        }

        public static interface WithMetadata {
            public Update withMetadata(Map<String, String> var1);
        }

        public static interface WithScopes {
            public Update withScopes(List<String> var1);
        }

        public static interface WithRoutes {
            public Update withRoutes(DaprSubscriptionRoutes var1);
        }

        public static interface WithDeadLetterTopic {
            public Update withDeadLetterTopic(String var1);
        }

        public static interface WithTopic {
            public Update withTopic(String var1);
        }

        public static interface WithPubsubName {
            public Update withPubsubName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithPubsubName,
    UpdateStages.WithTopic,
    UpdateStages.WithDeadLetterTopic,
    UpdateStages.WithRoutes,
    UpdateStages.WithScopes,
    UpdateStages.WithMetadata,
    UpdateStages.WithBulkSubscribe {
        public DaprSubscription apply();

        public DaprSubscription apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithBulkSubscribe {
            public WithCreate withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions var1);
        }

        public static interface WithMetadata {
            public WithCreate withMetadata(Map<String, String> var1);
        }

        public static interface WithScopes {
            public WithCreate withScopes(List<String> var1);
        }

        public static interface WithRoutes {
            public WithCreate withRoutes(DaprSubscriptionRoutes var1);
        }

        public static interface WithDeadLetterTopic {
            public WithCreate withDeadLetterTopic(String var1);
        }

        public static interface WithTopic {
            public WithCreate withTopic(String var1);
        }

        public static interface WithPubsubName {
            public WithCreate withPubsubName(String var1);
        }

        public static interface WithCreate
        extends WithPubsubName,
        WithTopic,
        WithDeadLetterTopic,
        WithRoutes,
        WithScopes,
        WithMetadata,
        WithBulkSubscribe {
            public DaprSubscription create();

            public DaprSubscription create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingManagedEnvironment(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

