/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.resourcemanager.appcontainers.models.CorsPolicy;
import com.azure.resourcemanager.appcontainers.models.CustomDomain;
import com.azure.resourcemanager.appcontainers.models.IngressClientCertificateMode;
import com.azure.resourcemanager.appcontainers.models.IngressPortMapping;
import com.azure.resourcemanager.appcontainers.models.IngressStickySessions;
import com.azure.resourcemanager.appcontainers.models.IngressTargetPortHttpScheme;
import com.azure.resourcemanager.appcontainers.models.IngressTransportMethod;
import com.azure.resourcemanager.appcontainers.models.IpSecurityRestrictionRule;
import com.azure.resourcemanager.appcontainers.models.TrafficWeight;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Ingress {
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;
    @JsonProperty(value="external")
    private Boolean external;
    @JsonProperty(value="targetPort")
    private Integer targetPort;
    @JsonProperty(value="exposedPort")
    private Integer exposedPort;
    @JsonProperty(value="transport")
    private IngressTransportMethod transport;
    @JsonProperty(value="traffic")
    private List<TrafficWeight> traffic;
    @JsonProperty(value="customDomains")
    private List<CustomDomain> customDomains;
    @JsonProperty(value="allowInsecure")
    private Boolean allowInsecure;
    @JsonProperty(value="ipSecurityRestrictions")
    private List<IpSecurityRestrictionRule> ipSecurityRestrictions;
    @JsonProperty(value="stickySessions")
    private IngressStickySessions stickySessions;
    @JsonProperty(value="clientCertificateMode")
    private IngressClientCertificateMode clientCertificateMode;
    @JsonProperty(value="corsPolicy")
    private CorsPolicy corsPolicy;
    @JsonProperty(value="additionalPortMappings")
    private List<IngressPortMapping> additionalPortMappings;
    @JsonProperty(value="targetPortHttpScheme")
    private IngressTargetPortHttpScheme targetPortHttpScheme;

    public String fqdn() {
        return this.fqdn;
    }

    public Boolean external() {
        return this.external;
    }

    public Ingress withExternal(Boolean external) {
        this.external = external;
        return this;
    }

    public Integer targetPort() {
        return this.targetPort;
    }

    public Ingress withTargetPort(Integer targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public Integer exposedPort() {
        return this.exposedPort;
    }

    public Ingress withExposedPort(Integer exposedPort) {
        this.exposedPort = exposedPort;
        return this;
    }

    public IngressTransportMethod transport() {
        return this.transport;
    }

    public Ingress withTransport(IngressTransportMethod transport) {
        this.transport = transport;
        return this;
    }

    public List<TrafficWeight> traffic() {
        return this.traffic;
    }

    public Ingress withTraffic(List<TrafficWeight> traffic) {
        this.traffic = traffic;
        return this;
    }

    public List<CustomDomain> customDomains() {
        return this.customDomains;
    }

    public Ingress withCustomDomains(List<CustomDomain> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public Boolean allowInsecure() {
        return this.allowInsecure;
    }

    public Ingress withAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    public List<IpSecurityRestrictionRule> ipSecurityRestrictions() {
        return this.ipSecurityRestrictions;
    }

    public Ingress withIpSecurityRestrictions(List<IpSecurityRestrictionRule> ipSecurityRestrictions) {
        this.ipSecurityRestrictions = ipSecurityRestrictions;
        return this;
    }

    public IngressStickySessions stickySessions() {
        return this.stickySessions;
    }

    public Ingress withStickySessions(IngressStickySessions stickySessions) {
        this.stickySessions = stickySessions;
        return this;
    }

    public IngressClientCertificateMode clientCertificateMode() {
        return this.clientCertificateMode;
    }

    public Ingress withClientCertificateMode(IngressClientCertificateMode clientCertificateMode) {
        this.clientCertificateMode = clientCertificateMode;
        return this;
    }

    public CorsPolicy corsPolicy() {
        return this.corsPolicy;
    }

    public Ingress withCorsPolicy(CorsPolicy corsPolicy) {
        this.corsPolicy = corsPolicy;
        return this;
    }

    public List<IngressPortMapping> additionalPortMappings() {
        return this.additionalPortMappings;
    }

    public Ingress withAdditionalPortMappings(List<IngressPortMapping> additionalPortMappings) {
        this.additionalPortMappings = additionalPortMappings;
        return this;
    }

    public IngressTargetPortHttpScheme targetPortHttpScheme() {
        return this.targetPortHttpScheme;
    }

    public Ingress withTargetPortHttpScheme(IngressTargetPortHttpScheme targetPortHttpScheme) {
        this.targetPortHttpScheme = targetPortHttpScheme;
        return this;
    }

    public void validate() {
        if (this.traffic() != null) {
            this.traffic().forEach(e -> e.validate());
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
        if (this.ipSecurityRestrictions() != null) {
            this.ipSecurityRestrictions().forEach(e -> e.validate());
        }
        if (this.stickySessions() != null) {
            this.stickySessions().validate();
        }
        if (this.corsPolicy() != null) {
            this.corsPolicy().validate();
        }
        if (this.additionalPortMappings() != null) {
            this.additionalPortMappings().forEach(e -> e.validate());
        }
    }
}

