// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceInner;
import com.azure.resourcemanager.appcontainers.models.BuilderResourceUpdate;

/**
 * An instance of this class provides access to all the operations defined in BuildersClient.
 */
public interface BuildersClient {
    /**
     * List BuilderResource resources by subscription ID.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a BuilderResource list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuilderResourceInner> list();

    /**
     * List BuilderResource resources by subscription ID.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a BuilderResource list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuilderResourceInner> list(Context context);

    /**
     * List BuilderResource resources by resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a BuilderResource list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuilderResourceInner> listByResourceGroup(String resourceGroupName);

    /**
     * List BuilderResource resources by resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a BuilderResource list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuilderResourceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Get a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a BuilderResource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BuilderResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String builderName,
        Context context);

    /**
     * Get a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a BuilderResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuilderResourceInner getByResourceGroup(String resourceGroupName, String builderName);

    /**
     * Create or update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BuilderResourceInner>, BuilderResourceInner> beginCreateOrUpdate(String resourceGroupName,
        String builderName, BuilderResourceInner builderEnvelope);

    /**
     * Create or update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BuilderResourceInner>, BuilderResourceInner> beginCreateOrUpdate(String resourceGroupName,
        String builderName, BuilderResourceInner builderEnvelope, Context context);

    /**
     * Create or update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuilderResourceInner createOrUpdate(String resourceGroupName, String builderName,
        BuilderResourceInner builderEnvelope);

    /**
     * Create or update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuilderResourceInner createOrUpdate(String resourceGroupName, String builderName,
        BuilderResourceInner builderEnvelope, Context context);

    /**
     * Update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope The resource properties to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BuilderResourceInner>, BuilderResourceInner> beginUpdate(String resourceGroupName,
        String builderName, BuilderResourceUpdate builderEnvelope);

    /**
     * Update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope The resource properties to be updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BuilderResourceInner>, BuilderResourceInner> beginUpdate(String resourceGroupName,
        String builderName, BuilderResourceUpdate builderEnvelope, Context context);

    /**
     * Update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope The resource properties to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuilderResourceInner update(String resourceGroupName, String builderName, BuilderResourceUpdate builderEnvelope);

    /**
     * Update a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param builderEnvelope The resource properties to be updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the SourceToCloud builder resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BuilderResourceInner update(String resourceGroupName, String builderName, BuilderResourceUpdate builderEnvelope,
        Context context);

    /**
     * Delete a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String builderName);

    /**
     * Delete a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String builderName, Context context);

    /**
     * Delete a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String builderName);

    /**
     * Delete a BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String builderName, Context context);
}
