// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;

/**
 * An instance of this class provides access to all the operations defined in BuildsByBuilderResourcesClient.
 */
public interface BuildsByBuilderResourcesClient {
    /**
     * List BuildResource resources by BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a BuildResource list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuildResourceInner> list(String resourceGroupName, String builderName);

    /**
     * List BuildResource resources by BuilderResource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a BuildResource list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BuildResourceInner> list(String resourceGroupName, String builderName, Context context);
}
