// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import com.azure.resourcemanager.appcontainers.models.SessionPoolUpdatableProperties;

/**
 * An instance of this class provides access to all the operations defined in ContainerAppsSessionPoolsClient.
 */
public interface ContainerAppsSessionPoolsClient {
    /**
     * Get the session pools in a given subscription.
     * 
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SessionPoolInner> list();

    /**
     * Get the session pools in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SessionPoolInner> list(Context context);

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SessionPoolInner> listByResourceGroup(String resourceGroupName);

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SessionPoolInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SessionPoolInner> getByResourceGroupWithResponse(String resourceGroupName, String sessionPoolName,
        Context context);

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SessionPoolInner getByResourceGroup(String resourceGroupName, String sessionPoolName);

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginCreateOrUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolInner sessionPoolEnvelope);

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginCreateOrUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolInner sessionPoolEnvelope, Context context);

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SessionPoolInner createOrUpdate(String resourceGroupName, String sessionPoolName,
        SessionPoolInner sessionPoolEnvelope);

    /**
     * Create or update a session pool.
     * 
     * Create or update a session pool with the given properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SessionPoolInner createOrUpdate(String resourceGroupName, String sessionPoolName,
        SessionPoolInner sessionPoolEnvelope, Context context);

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolUpdatableProperties sessionPoolEnvelope);

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App session pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SessionPoolInner>, SessionPoolInner> beginUpdate(String resourceGroupName,
        String sessionPoolName, SessionPoolUpdatableProperties sessionPoolEnvelope, Context context);

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SessionPoolInner update(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope);

    /**
     * Update properties of a session pool
     * 
     * Patches a session pool using JSON merge patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param sessionPoolEnvelope Properties used to create a session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App session pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SessionPoolInner update(String resourceGroupName, String sessionPoolName,
        SessionPoolUpdatableProperties sessionPoolEnvelope, Context context);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sessionPoolName);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sessionPoolName, Context context);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String sessionPoolName);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String sessionPoolName, Context context);
}
