// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentResiliencyPolicyInner;

/**
 * An instance of this class provides access to all the operations defined in DaprComponentResiliencyPoliciesClient.
 */
public interface DaprComponentResiliencyPoliciesClient {
    /**
     * Get the resiliency policies for a Dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the resiliency policies for a Dapr component as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DaprComponentResiliencyPolicyInner> list(String resourceGroupName, String environmentName,
        String componentName);

    /**
     * Get the resiliency policies for a Dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the resiliency policies for a Dapr component as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DaprComponentResiliencyPolicyInner> list(String resourceGroupName, String environmentName,
        String componentName, Context context);

    /**
     * Get a Dapr component resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Dapr component resiliency policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DaprComponentResiliencyPolicyInner> getWithResponse(String resourceGroupName, String environmentName,
        String componentName, String name, Context context);

    /**
     * Get a Dapr component resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Dapr component resiliency policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DaprComponentResiliencyPolicyInner get(String resourceGroupName, String environmentName, String componentName,
        String name);

    /**
     * Creates or updates a Dapr component resiliency policy.
     * 
     * Creates or updates a resiliency policy for a Dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @param daprComponentResiliencyPolicyEnvelope Configuration details of the Dapr Component Resiliency Policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component Resiliency Policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DaprComponentResiliencyPolicyInner> createOrUpdateWithResponse(String resourceGroupName,
        String environmentName, String componentName, String name,
        DaprComponentResiliencyPolicyInner daprComponentResiliencyPolicyEnvelope, Context context);

    /**
     * Creates or updates a Dapr component resiliency policy.
     * 
     * Creates or updates a resiliency policy for a Dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @param daprComponentResiliencyPolicyEnvelope Configuration details of the Dapr Component Resiliency Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component Resiliency Policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DaprComponentResiliencyPolicyInner createOrUpdate(String resourceGroupName, String environmentName,
        String componentName, String name, DaprComponentResiliencyPolicyInner daprComponentResiliencyPolicyEnvelope);

    /**
     * Delete a Dapr component resiliency policy.
     * 
     * Delete a resiliency policy for a Dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String componentName,
        String name, Context context);

    /**
     * Delete a Dapr component resiliency policy.
     * 
     * Delete a resiliency policy for a Dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param name Name of the Dapr Component Resiliency Policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String environmentName, String componentName, String name);
}
