// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;

/**
 * An instance of this class provides access to all the operations defined in DotNetComponentsClient.
 */
public interface DotNetComponentsClient {
    /**
     * Get the .NET Components for a managed environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the .NET Components for a managed environment as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DotNetComponentInner> list(String resourceGroupName, String environmentName);

    /**
     * Get the .NET Components for a managed environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the .NET Components for a managed environment as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DotNetComponentInner> list(String resourceGroupName, String environmentName, Context context);

    /**
     * Get a .NET Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a .NET Component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DotNetComponentInner> getWithResponse(String resourceGroupName, String environmentName, String name,
        Context context);

    /**
     * Get a .NET Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a .NET Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DotNetComponentInner get(String resourceGroupName, String environmentName, String name);

    /**
     * Creates or updates a .NET Component.
     * 
     * Creates or updates a .NET Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of .NET Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DotNetComponentInner>, DotNetComponentInner> beginCreateOrUpdate(String resourceGroupName,
        String environmentName, String name, DotNetComponentInner dotNetComponentEnvelope);

    /**
     * Creates or updates a .NET Component.
     * 
     * Creates or updates a .NET Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of .NET Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DotNetComponentInner>, DotNetComponentInner> beginCreateOrUpdate(String resourceGroupName,
        String environmentName, String name, DotNetComponentInner dotNetComponentEnvelope, Context context);

    /**
     * Creates or updates a .NET Component.
     * 
     * Creates or updates a .NET Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return .NET Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DotNetComponentInner createOrUpdate(String resourceGroupName, String environmentName, String name,
        DotNetComponentInner dotNetComponentEnvelope);

    /**
     * Creates or updates a .NET Component.
     * 
     * Creates or updates a .NET Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return .NET Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DotNetComponentInner createOrUpdate(String resourceGroupName, String environmentName, String name,
        DotNetComponentInner dotNetComponentEnvelope, Context context);

    /**
     * Update properties of a .NET Component
     * 
     * Patches a .NET Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of .NET Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DotNetComponentInner>, DotNetComponentInner> beginUpdate(String resourceGroupName,
        String environmentName, String name, DotNetComponentInner dotNetComponentEnvelope);

    /**
     * Update properties of a .NET Component
     * 
     * Patches a .NET Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of .NET Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DotNetComponentInner>, DotNetComponentInner> beginUpdate(String resourceGroupName,
        String environmentName, String name, DotNetComponentInner dotNetComponentEnvelope, Context context);

    /**
     * Update properties of a .NET Component
     * 
     * Patches a .NET Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return .NET Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DotNetComponentInner update(String resourceGroupName, String environmentName, String name,
        DotNetComponentInner dotNetComponentEnvelope);

    /**
     * Update properties of a .NET Component
     * 
     * Patches a .NET Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param dotNetComponentEnvelope Configuration details of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return .NET Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DotNetComponentInner update(String resourceGroupName, String environmentName, String name,
        DotNetComponentInner dotNetComponentEnvelope, Context context);

    /**
     * Delete a .NET Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String environmentName, String name);

    /**
     * Delete a .NET Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String environmentName, String name,
        Context context);

    /**
     * Delete a .NET Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String environmentName, String name);

    /**
     * Delete a .NET Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the .NET Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String environmentName, String name, Context context);
}
