// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;

/**
 * An instance of this class provides access to all the operations defined in JavaComponentsClient.
 */
public interface JavaComponentsClient {
    /**
     * Get the Java Components for a managed environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Java Components for a managed environment as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<JavaComponentInner> list(String resourceGroupName, String environmentName);

    /**
     * Get the Java Components for a managed environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Java Components for a managed environment as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<JavaComponentInner> list(String resourceGroupName, String environmentName, Context context);

    /**
     * Get a Java Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Java Component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<JavaComponentInner> getWithResponse(String resourceGroupName, String environmentName, String name,
        Context context);

    /**
     * Get a Java Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Java Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    JavaComponentInner get(String resourceGroupName, String environmentName, String name);

    /**
     * Creates or updates a Java Component.
     * 
     * Creates or updates a Java Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of java Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<JavaComponentInner>, JavaComponentInner> beginCreateOrUpdate(String resourceGroupName,
        String environmentName, String name, JavaComponentInner javaComponentEnvelope);

    /**
     * Creates or updates a Java Component.
     * 
     * Creates or updates a Java Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of java Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<JavaComponentInner>, JavaComponentInner> beginCreateOrUpdate(String resourceGroupName,
        String environmentName, String name, JavaComponentInner javaComponentEnvelope, Context context);

    /**
     * Creates or updates a Java Component.
     * 
     * Creates or updates a Java Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return java Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    JavaComponentInner createOrUpdate(String resourceGroupName, String environmentName, String name,
        JavaComponentInner javaComponentEnvelope);

    /**
     * Creates or updates a Java Component.
     * 
     * Creates or updates a Java Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return java Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    JavaComponentInner createOrUpdate(String resourceGroupName, String environmentName, String name,
        JavaComponentInner javaComponentEnvelope, Context context);

    /**
     * Update properties of a Java Component
     * 
     * Patches a Java Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of java Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<JavaComponentInner>, JavaComponentInner> beginUpdate(String resourceGroupName,
        String environmentName, String name, JavaComponentInner javaComponentEnvelope);

    /**
     * Update properties of a Java Component
     * 
     * Patches a Java Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of java Component.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<JavaComponentInner>, JavaComponentInner> beginUpdate(String resourceGroupName,
        String environmentName, String name, JavaComponentInner javaComponentEnvelope, Context context);

    /**
     * Update properties of a Java Component
     * 
     * Patches a Java Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return java Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    JavaComponentInner update(String resourceGroupName, String environmentName, String name,
        JavaComponentInner javaComponentEnvelope);

    /**
     * Update properties of a Java Component
     * 
     * Patches a Java Component using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param javaComponentEnvelope Configuration details of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return java Component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    JavaComponentInner update(String resourceGroupName, String environmentName, String name,
        JavaComponentInner javaComponentEnvelope, Context context);

    /**
     * Delete a Java Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String environmentName, String name);

    /**
     * Delete a Java Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String environmentName, String name,
        Context context);

    /**
     * Delete a Java Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String environmentName, String name);

    /**
     * Delete a Java Component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param name Name of the Java Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String environmentName, String name, Context context);
}
