// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.LogicAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkflowEnvelopeInner;
import com.azure.resourcemanager.appcontainers.models.LogicAppsProxyMethod;
import com.azure.resourcemanager.appcontainers.models.WorkflowArtifacts;

/**
 * An instance of this class provides access to all the operations defined in LogicAppsClient.
 */
public interface LogicAppsClient {
    /**
     * Gets a logic app extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LogicAppInner> getWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        Context context);

    /**
     * Gets a logic app extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LogicAppInner get(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * Create or update a Logic App extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param resource Logic app resource properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LogicAppInner> createOrUpdateWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, LogicAppInner resource, Context context);

    /**
     * Create or update a Logic App extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param resource Logic app resource properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a logic app extension resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LogicAppInner createOrUpdate(String resourceGroupName, String containerAppName, String logicAppName,
        LogicAppInner resource);

    /**
     * Deletes a Logic App extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        Context context);

    /**
     * Deletes a Logic App extension resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * List the workflows for a logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of workflow information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<WorkflowEnvelopeInner> listWorkflows(String resourceGroupName, String containerAppName,
        String logicAppName);

    /**
     * List the workflows for a logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of workflow information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<WorkflowEnvelopeInner> listWorkflows(String resourceGroupName, String containerAppName,
        String logicAppName, Context context);

    /**
     * Get workflow information by its name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param workflowName Workflow name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workflow information by its name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<WorkflowEnvelopeInner> getWorkflowWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, String workflowName, Context context);

    /**
     * Get workflow information by its name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param workflowName Workflow name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workflow information by its name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WorkflowEnvelopeInner getWorkflow(String resourceGroupName, String containerAppName, String logicAppName,
        String workflowName);

    /**
     * Creates or updates the artifacts for the logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param workflowArtifacts Application settings and files of the workflow.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deployWorkflowArtifactsWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, WorkflowArtifacts workflowArtifacts, Context context);

    /**
     * Creates or updates the artifacts for the logic app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deployWorkflowArtifacts(String resourceGroupName, String containerAppName, String logicAppName);

    /**
     * Gets logic app's connections.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return logic app's connections along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<WorkflowEnvelopeInner> listWorkflowsConnectionsWithResponse(String resourceGroupName,
        String containerAppName, String logicAppName, Context context);

    /**
     * Gets logic app's connections.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the Logic App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return logic app's connections.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WorkflowEnvelopeInner listWorkflowsConnections(String resourceGroupName, String containerAppName,
        String logicAppName);

    /**
     * Proxies a the API call to the logic app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the LogicApp App, the extension resource.
     * @param xMsLogicAppsProxyPath The proxy path for the API call.
     * @param xMsLogicAppsProxyMethod The proxy method for the API call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> invokeWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod, Context context);

    /**
     * Proxies a the API call to the logic app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param logicAppName Name of the LogicApp App, the extension resource.
     * @param xMsLogicAppsProxyPath The proxy path for the API call.
     * @param xMsLogicAppsProxyMethod The proxy method for the API call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object invoke(String resourceGroupName, String containerAppName, String logicAppName, String xMsLogicAppsProxyPath,
        LogicAppsProxyMethod xMsLogicAppsProxyMethod);
}
