// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CircuitBreakerPolicy;
import com.azure.resourcemanager.appcontainers.models.HttpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.HttpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TcpConnectionPool;
import com.azure.resourcemanager.appcontainers.models.TcpRetryPolicy;
import com.azure.resourcemanager.appcontainers.models.TimeoutPolicy;
import java.io.IOException;

/**
 * Configuration to setup App Resiliency.
 */
@Fluent
public final class AppResiliencyInner extends ProxyResource {
    /*
     * App Resiliency resource specific properties
     */
    private AppResiliencyProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AppResiliencyInner class.
     */
    public AppResiliencyInner() {
    }

    /**
     * Get the innerProperties property: App Resiliency resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private AppResiliencyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the timeoutPolicy property: Policy to set request timeouts.
     * 
     * @return the timeoutPolicy value.
     */
    public TimeoutPolicy timeoutPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().timeoutPolicy();
    }

    /**
     * Set the timeoutPolicy property: Policy to set request timeouts.
     * 
     * @param timeoutPolicy the timeoutPolicy value to set.
     * @return the AppResiliencyInner object itself.
     */
    public AppResiliencyInner withTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withTimeoutPolicy(timeoutPolicy);
        return this;
    }

    /**
     * Get the httpRetryPolicy property: Policy that defines http request retry conditions.
     * 
     * @return the httpRetryPolicy value.
     */
    public HttpRetryPolicy httpRetryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().httpRetryPolicy();
    }

    /**
     * Set the httpRetryPolicy property: Policy that defines http request retry conditions.
     * 
     * @param httpRetryPolicy the httpRetryPolicy value to set.
     * @return the AppResiliencyInner object itself.
     */
    public AppResiliencyInner withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withHttpRetryPolicy(httpRetryPolicy);
        return this;
    }

    /**
     * Get the tcpRetryPolicy property: Policy that defines tcp request retry conditions.
     * 
     * @return the tcpRetryPolicy value.
     */
    public TcpRetryPolicy tcpRetryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().tcpRetryPolicy();
    }

    /**
     * Set the tcpRetryPolicy property: Policy that defines tcp request retry conditions.
     * 
     * @param tcpRetryPolicy the tcpRetryPolicy value to set.
     * @return the AppResiliencyInner object itself.
     */
    public AppResiliencyInner withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withTcpRetryPolicy(tcpRetryPolicy);
        return this;
    }

    /**
     * Get the circuitBreakerPolicy property: Policy that defines circuit breaker conditions.
     * 
     * @return the circuitBreakerPolicy value.
     */
    public CircuitBreakerPolicy circuitBreakerPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().circuitBreakerPolicy();
    }

    /**
     * Set the circuitBreakerPolicy property: Policy that defines circuit breaker conditions.
     * 
     * @param circuitBreakerPolicy the circuitBreakerPolicy value to set.
     * @return the AppResiliencyInner object itself.
     */
    public AppResiliencyInner withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withCircuitBreakerPolicy(circuitBreakerPolicy);
        return this;
    }

    /**
     * Get the httpConnectionPool property: Defines parameters for http connection pooling.
     * 
     * @return the httpConnectionPool value.
     */
    public HttpConnectionPool httpConnectionPool() {
        return this.innerProperties() == null ? null : this.innerProperties().httpConnectionPool();
    }

    /**
     * Set the httpConnectionPool property: Defines parameters for http connection pooling.
     * 
     * @param httpConnectionPool the httpConnectionPool value to set.
     * @return the AppResiliencyInner object itself.
     */
    public AppResiliencyInner withHttpConnectionPool(HttpConnectionPool httpConnectionPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withHttpConnectionPool(httpConnectionPool);
        return this;
    }

    /**
     * Get the tcpConnectionPool property: Defines parameters for tcp connection pooling.
     * 
     * @return the tcpConnectionPool value.
     */
    public TcpConnectionPool tcpConnectionPool() {
        return this.innerProperties() == null ? null : this.innerProperties().tcpConnectionPool();
    }

    /**
     * Set the tcpConnectionPool property: Defines parameters for tcp connection pooling.
     * 
     * @param tcpConnectionPool the tcpConnectionPool value to set.
     * @return the AppResiliencyInner object itself.
     */
    public AppResiliencyInner withTcpConnectionPool(TcpConnectionPool tcpConnectionPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppResiliencyProperties();
        }
        this.innerProperties().withTcpConnectionPool(tcpConnectionPool);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppResiliencyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppResiliencyInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppResiliencyInner.
     */
    public static AppResiliencyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppResiliencyInner deserializedAppResiliencyInner = new AppResiliencyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAppResiliencyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAppResiliencyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAppResiliencyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAppResiliencyInner.innerProperties = AppResiliencyProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedAppResiliencyInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppResiliencyInner;
        });
    }
}
