// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AuthPlatform;
import com.azure.resourcemanager.appcontainers.models.EncryptionSettings;
import com.azure.resourcemanager.appcontainers.models.GlobalValidation;
import com.azure.resourcemanager.appcontainers.models.HttpSettings;
import com.azure.resourcemanager.appcontainers.models.IdentityProviders;
import com.azure.resourcemanager.appcontainers.models.Login;
import java.io.IOException;

/**
 * Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
 */
@Fluent
public final class AuthConfigInner extends ProxyResource {
    /*
     * AuthConfig resource specific properties
     */
    private AuthConfigProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AuthConfigInner class.
     */
    public AuthConfigInner() {
    }

    /**
     * Get the innerProperties property: AuthConfig resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private AuthConfigProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the platform property: The configuration settings of the platform of ContainerApp Service
     * Authentication/Authorization.
     * 
     * @return the platform value.
     */
    public AuthPlatform platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    /**
     * Set the platform property: The configuration settings of the platform of ContainerApp Service
     * Authentication/Authorization.
     * 
     * @param platform the platform value to set.
     * @return the AuthConfigInner object itself.
     */
    public AuthConfigInner withPlatform(AuthPlatform platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    /**
     * Get the globalValidation property: The configuration settings that determines the validation flow of users using
     * Service Authentication/Authorization.
     * 
     * @return the globalValidation value.
     */
    public GlobalValidation globalValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().globalValidation();
    }

    /**
     * Set the globalValidation property: The configuration settings that determines the validation flow of users using
     * Service Authentication/Authorization.
     * 
     * @param globalValidation the globalValidation value to set.
     * @return the AuthConfigInner object itself.
     */
    public AuthConfigInner withGlobalValidation(GlobalValidation globalValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withGlobalValidation(globalValidation);
        return this;
    }

    /**
     * Get the identityProviders property: The configuration settings of each of the identity providers used to
     * configure ContainerApp Service Authentication/Authorization.
     * 
     * @return the identityProviders value.
     */
    public IdentityProviders identityProviders() {
        return this.innerProperties() == null ? null : this.innerProperties().identityProviders();
    }

    /**
     * Set the identityProviders property: The configuration settings of each of the identity providers used to
     * configure ContainerApp Service Authentication/Authorization.
     * 
     * @param identityProviders the identityProviders value to set.
     * @return the AuthConfigInner object itself.
     */
    public AuthConfigInner withIdentityProviders(IdentityProviders identityProviders) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withIdentityProviders(identityProviders);
        return this;
    }

    /**
     * Get the login property: The configuration settings of the login flow of users using ContainerApp Service
     * Authentication/Authorization.
     * 
     * @return the login value.
     */
    public Login login() {
        return this.innerProperties() == null ? null : this.innerProperties().login();
    }

    /**
     * Set the login property: The configuration settings of the login flow of users using ContainerApp Service
     * Authentication/Authorization.
     * 
     * @param login the login value to set.
     * @return the AuthConfigInner object itself.
     */
    public AuthConfigInner withLogin(Login login) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withLogin(login);
        return this;
    }

    /**
     * Get the httpSettings property: The configuration settings of the HTTP requests for authentication and
     * authorization requests made against ContainerApp Service Authentication/Authorization.
     * 
     * @return the httpSettings value.
     */
    public HttpSettings httpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().httpSettings();
    }

    /**
     * Set the httpSettings property: The configuration settings of the HTTP requests for authentication and
     * authorization requests made against ContainerApp Service Authentication/Authorization.
     * 
     * @param httpSettings the httpSettings value to set.
     * @return the AuthConfigInner object itself.
     */
    public AuthConfigInner withHttpSettings(HttpSettings httpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withHttpSettings(httpSettings);
        return this;
    }

    /**
     * Get the encryptionSettings property: The configuration settings of the secrets references of encryption key and
     * signing key for ContainerApp Service Authentication/Authorization.
     * 
     * @return the encryptionSettings value.
     */
    public EncryptionSettings encryptionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettings();
    }

    /**
     * Set the encryptionSettings property: The configuration settings of the secrets references of encryption key and
     * signing key for ContainerApp Service Authentication/Authorization.
     * 
     * @param encryptionSettings the encryptionSettings value to set.
     * @return the AuthConfigInner object itself.
     */
    public AuthConfigInner withEncryptionSettings(EncryptionSettings encryptionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthConfigProperties();
        }
        this.innerProperties().withEncryptionSettings(encryptionSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthConfigInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthConfigInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AuthConfigInner.
     */
    public static AuthConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthConfigInner deserializedAuthConfigInner = new AuthConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAuthConfigInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAuthConfigInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAuthConfigInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAuthConfigInner.innerProperties = AuthConfigProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedAuthConfigInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthConfigInner;
        });
    }
}
