// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

/**
 * The build properties.
 */
@Fluent
public final class BuildProperties implements JsonSerializable<BuildProperties> {
    /*
     * Build provisioning state.
     */
    private BuildProvisioningState provisioningState;

    /*
     * Status of the build once it has been provisioned.
     */
    private BuildStatus buildStatus;

    /*
     * Container registry that the final image will be uploaded to.
     */
    private ContainerRegistryWithCustomImage destinationContainerRegistry;

    /*
     * Configuration of the build.
     */
    private BuildConfiguration configuration;

    /*
     * Endpoint to which the source code should be uploaded.
     */
    private String uploadEndpoint;

    /*
     * Endpoint from which the build logs can be streamed.
     */
    private String logStreamEndpoint;

    /*
     * Endpoint to use to retrieve an authentication token for log streaming and uploading source code.
     */
    private String tokenEndpoint;

    /**
     * Creates an instance of BuildProperties class.
     */
    public BuildProperties() {
    }

    /**
     * Get the provisioningState property: Build provisioning state.
     * 
     * @return the provisioningState value.
     */
    public BuildProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the buildStatus property: Status of the build once it has been provisioned.
     * 
     * @return the buildStatus value.
     */
    public BuildStatus buildStatus() {
        return this.buildStatus;
    }

    /**
     * Get the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @return the destinationContainerRegistry value.
     */
    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.destinationContainerRegistry;
    }

    /**
     * Set the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @param destinationContainerRegistry the destinationContainerRegistry value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties
        withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry) {
        this.destinationContainerRegistry = destinationContainerRegistry;
        return this;
    }

    /**
     * Get the configuration property: Configuration of the build.
     * 
     * @return the configuration value.
     */
    public BuildConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Configuration of the build.
     * 
     * @param configuration the configuration value to set.
     * @return the BuildProperties object itself.
     */
    public BuildProperties withConfiguration(BuildConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the uploadEndpoint property: Endpoint to which the source code should be uploaded.
     * 
     * @return the uploadEndpoint value.
     */
    public String uploadEndpoint() {
        return this.uploadEndpoint;
    }

    /**
     * Get the logStreamEndpoint property: Endpoint from which the build logs can be streamed.
     * 
     * @return the logStreamEndpoint value.
     */
    public String logStreamEndpoint() {
        return this.logStreamEndpoint;
    }

    /**
     * Get the tokenEndpoint property: Endpoint to use to retrieve an authentication token for log streaming and
     * uploading source code.
     * 
     * @return the tokenEndpoint value.
     */
    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destinationContainerRegistry() != null) {
            destinationContainerRegistry().validate();
        }
        if (configuration() != null) {
            configuration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destinationContainerRegistry", this.destinationContainerRegistry);
        jsonWriter.writeJsonField("configuration", this.configuration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildProperties.
     */
    public static BuildProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildProperties deserializedBuildProperties = new BuildProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildProperties.provisioningState
                        = BuildProvisioningState.fromString(reader.getString());
                } else if ("buildStatus".equals(fieldName)) {
                    deserializedBuildProperties.buildStatus = BuildStatus.fromString(reader.getString());
                } else if ("destinationContainerRegistry".equals(fieldName)) {
                    deserializedBuildProperties.destinationContainerRegistry
                        = ContainerRegistryWithCustomImage.fromJson(reader);
                } else if ("configuration".equals(fieldName)) {
                    deserializedBuildProperties.configuration = BuildConfiguration.fromJson(reader);
                } else if ("uploadEndpoint".equals(fieldName)) {
                    deserializedBuildProperties.uploadEndpoint = reader.getString();
                } else if ("logStreamEndpoint".equals(fieldName)) {
                    deserializedBuildProperties.logStreamEndpoint = reader.getString();
                } else if ("tokenEndpoint".equals(fieldName)) {
                    deserializedBuildProperties.tokenEndpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildProperties;
        });
    }
}
