// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.ContainerRegistryWithCustomImage;
import java.io.IOException;

/**
 * Information pertaining to an individual build.
 */
@Fluent
public final class BuildResourceInner extends ProxyResource {
    /*
     * The resource-specific properties for this resource.
     */
    private BuildProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of BuildResourceInner class.
     */
    public BuildResourceInner() {
    }

    /**
     * Get the innerProperties property: The resource-specific properties for this resource.
     * 
     * @return the innerProperties value.
     */
    private BuildProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: Build provisioning state.
     * 
     * @return the provisioningState value.
     */
    public BuildProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the buildStatus property: Status of the build once it has been provisioned.
     * 
     * @return the buildStatus value.
     */
    public BuildStatus buildStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().buildStatus();
    }

    /**
     * Get the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @return the destinationContainerRegistry value.
     */
    public ContainerRegistryWithCustomImage destinationContainerRegistry() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationContainerRegistry();
    }

    /**
     * Set the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @param destinationContainerRegistry the destinationContainerRegistry value to set.
     * @return the BuildResourceInner object itself.
     */
    public BuildResourceInner
        withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuildProperties();
        }
        this.innerProperties().withDestinationContainerRegistry(destinationContainerRegistry);
        return this;
    }

    /**
     * Get the configuration property: Configuration of the build.
     * 
     * @return the configuration value.
     */
    public BuildConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    /**
     * Set the configuration property: Configuration of the build.
     * 
     * @param configuration the configuration value to set.
     * @return the BuildResourceInner object itself.
     */
    public BuildResourceInner withConfiguration(BuildConfiguration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuildProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    /**
     * Get the uploadEndpoint property: Endpoint to which the source code should be uploaded.
     * 
     * @return the uploadEndpoint value.
     */
    public String uploadEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().uploadEndpoint();
    }

    /**
     * Get the logStreamEndpoint property: Endpoint from which the build logs can be streamed.
     * 
     * @return the logStreamEndpoint value.
     */
    public String logStreamEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().logStreamEndpoint();
    }

    /**
     * Get the tokenEndpoint property: Endpoint to use to retrieve an authentication token for log streaming and
     * uploading source code.
     * 
     * @return the tokenEndpoint value.
     */
    public String tokenEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().tokenEndpoint();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildResourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BuildResourceInner.
     */
    public static BuildResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildResourceInner deserializedBuildResourceInner = new BuildResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBuildResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBuildResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBuildResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedBuildResourceInner.innerProperties = BuildProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedBuildResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildResourceInner;
        });
    }
}
